/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.content;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.PageContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.links.linktypes.AbstractContentEntityLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import java.util.Collection;
import java.util.HashSet;
import org.randombits.confluence.filtering.criteria.CriteriaException;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;
import org.randombits.confluence.filtering.criteria.SourceCriterion;
import org.randombits.confluence.support.LinkAssistant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentScopeCriterion
implements SourceCriterion<ContentEntityObject> {
    public static final int SELF_SCOPE = 1;
    public static final int CHILDREN_SCOPE = 2;
    public static final int DESCENDENTS_SCOPE = 4;
    public static final int ANCESTORS_SCOPE = 8;
    private ContentEntityObject rootContent;
    private int scope;

    public ContentScopeCriterion(ContentEntityObject ceo) {
        this(ceo, 1);
    }

    public ContentScopeCriterion(ContentEntityObject ceo, int scope) {
        this.rootContent = ceo;
        this.scope = scope;
    }

    @Override
    public boolean matches(Object object) {
        AbstractPage ceo = null;
        if (object instanceof PageContentEntityObject) {
            ceo = ((PageContentEntityObject)object).getPage();
        } else if (object instanceof ContentEntityObject) {
            ceo = (ContentEntityObject)object;
        } else if (object instanceof Attachment) {
            ceo = ((Attachment)object).getContent();
        } else if (object instanceof AbstractContentEntityLink) {
            ceo = ((AbstractContentEntityLink)object).getDestinationContent();
        }
        if (ceo != null) {
            if (this.hasScope(1) && this.rootContent.equals((Object)ceo)) {
                return true;
            }
            if (this.scope != 1 && this.rootContent instanceof Page && ceo instanceof Page) {
                Page page = (Page)ceo;
                if (this.hasScope(2) && this.rootContent.equals((Object)page.getParent())) {
                    return true;
                }
                if (this.hasScope(4) && this.isAncestor(page, (Page)this.rootContent)) {
                    return true;
                }
                if (this.hasScope(8) && this.isAncestor((Page)this.rootContent, page)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasScope(int checkScope) {
        return (this.scope & checkScope) != 0;
    }

    private boolean isAncestor(Page page, Page ancestor) {
        for (page = page.getParent(); page != null && !page.equals((Object)ancestor); page = page.getParent()) {
        }
        return page != null;
    }

    public String toString() {
        return "{content scope: " + this.rootContent + (this.scope == 0 ? "" : " >" + (this.hasScope(2) ? " children" : "") + (this.hasScope(4) ? " descendents" : "") + (this.hasScope(8) ? " ancestors" : "")) + "}";
    }

    @Override
    public Collection<ContentEntityObject> getMatchingValues() {
        HashSet<ContentEntityObject> values = new HashSet<ContentEntityObject>();
        if (this.rootContent != null && this.scope == 0) {
            if (this.hasScope(1)) {
                values.add(this.rootContent);
            }
            if (this.rootContent instanceof Page) {
                Page page = (Page)this.rootContent;
                if (this.hasScope(4)) {
                    values.addAll(page.getDescendents());
                } else if (this.hasScope(2)) {
                    values.addAll(page.getChildren());
                }
                if (this.hasScope(8)) {
                    values.addAll(page.getAncestors());
                }
            }
        }
        return values;
    }

    @Override
    public SourceCriterion.Weight getWeight() {
        return SourceCriterion.Weight.MEDIUM;
    }

    public static class Interpreter
    implements CriterionInterpreter {
        public static final char SCOPE_DELIMITER = '>';
        private ContentEntityObject content;

        public Interpreter() {
            this(null);
        }

        public Interpreter(ContentEntityObject content) {
            this.content = content;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Criterion createCriterion(String value) throws CriteriaException {
            int scopeIndex = value.indexOf(62);
            int scope = 0;
            if (scopeIndex >= 0) {
                String scopeString = value.substring(scopeIndex + 1).trim().toLowerCase();
                value = value.substring(0, scopeIndex).trim();
                if ("ancestors".equals(scopeString)) {
                    scope += 8;
                } else if ("children".equals(scopeString)) {
                    scope += 2;
                } else {
                    if (!"descendents".equals(scopeString) && !"descendants".equals(scopeString)) throw new CriteriaException("Unsupported scope: " + scopeString);
                    scope += 4;
                }
            } else {
                scope = 1;
            }
            ContentEntityObject context = null;
            if ("@self".equals(value)) {
                context = this.content;
            } else if ("@parent".equals(value)) {
                if (!(this.content instanceof Page)) throw new CriteriaException("@parent can only be used on pages.");
                context = ((Page)this.content).getParent();
            } else if ("@home".equals(value)) {
                Space space;
                if (this.content instanceof SpaceContentEntityObject && (space = ((SpaceContentEntityObject)this.content).getSpace()) != null) {
                    context = space.getHomePage();
                }
            } else {
                ConfluenceEntityObject entity = LinkAssistant.getInstance().getLinkedEntity(this.content.toPageContext(), value);
                if (entity instanceof ContentEntityObject) {
                    context = (ContentEntityObject)entity;
                }
            }
            if (context == null) throw new CriteriaException("Unable to locate the specified content: '" + value + "'");
            return new ContentScopeCriterion(context, scope);
        }
    }
}

