/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.stateRepository.task;

import com.atlassian.core.task.Task;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.stateRepository.WorkflowStateRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateRepositoryQueueTask
implements Task {
    private static final Logger log = LoggerFactory.getLogger(StateRepositoryQueueTask.class);
    private StatesContainer statesContainer;
    private String spaceKey;

    public StateRepositoryQueueTask(StatesContainer statesContainer, String spaceKey) {
        this.statesContainer = statesContainer;
        this.spaceKey = spaceKey;
    }

    public void execute() throws Exception {
        WorkflowStateRepository workflowStateRepository = this.getWorkflowStateRepository();
        log.debug("Saving state names in bandana for space " + this.spaceKey);
        workflowStateRepository.setSpaceKeyStateNames(this.statesContainer, this.spaceKey);
        workflowStateRepository.setInstanceStateNames(this.statesContainer);
    }

    private WorkflowStateRepository getWorkflowStateRepository() {
        return PluginContainerManager.getComponent(WorkflowStateRepository.class);
    }
}

