/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.actions;

import com.atlassian.confluence.pages.AbstractPage;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewPageCookieUtils {
    private static final Logger log = LoggerFactory.getLogger(ViewPageCookieUtils.class);
    protected static final int COOKIE_TTL = 3600;
    protected static final String DRAFT_FLAG = "draft";

    public static boolean isViewDraft(AbstractPage page) {
        String cookie = ViewPageCookieUtils.getCookieValue(ViewPageCookieUtils.makeCookieKey(page));
        if (!StringUtils.isNotBlank((CharSequence)cookie)) {
            return false;
        }
        return DRAFT_FLAG.equals(cookie);
    }

    public static void setViewPublished(AbstractPage page) {
        String key = ViewPageCookieUtils.makeCookieKey(page);
        if (!StringUtils.isNotBlank((CharSequence)ViewPageCookieUtils.getCookieValue(key))) {
            return;
        }
        ViewPageCookieUtils.removeCookie(key);
    }

    public static void setViewDraft(AbstractPage page) {
        ViewPageCookieUtils.setCookie(ViewPageCookieUtils.makeCookieKey(page), DRAFT_FLAG, 3600);
    }

    private static String makeCookieKey(AbstractPage page) {
        return "comalatech.awp.view." + page.getIdAsString();
    }

    private static Cookie setCookie(String key, String value, int ttl) {
        try {
            HttpServletRequest request = ServletActionContext.getRequest();
            if (request == null) {
                return null;
            }
            HttpServletResponse response = ServletActionContext.getResponse();
            String path = request.getContextPath();
            if (StringUtils.isEmpty((CharSequence)path)) {
                path = "/";
            }
            Cookie cookie = new Cookie(key, value);
            cookie.setMaxAge(ttl);
            cookie.setPath(path);
            cookie.setSecure(request.isSecure());
            response.addCookie(cookie);
            return cookie;
        }
        catch (Exception ex) {
            log.info("There has been an error setting the cookie key {} : {}", (Object)key, (Object)ex.getMessage());
            return null;
        }
    }

    private static void removeCookie(String key) {
        ViewPageCookieUtils.setCookie(key, null, 0);
    }

    private static String getCookieValue(String key) {
        Cookie cookie;
        HttpServletRequest request = ServletActionContext.getRequest();
        if (request != null && (cookie = ViewPageCookieUtils.getCookie(request, key)) != null) {
            return cookie.getValue();
        }
        return null;
    }

    private static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies;
        if (!StringUtils.isEmpty((CharSequence)name) && (cookies = request.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(name)) continue;
                return cookies[i];
            }
        }
        return null;
    }
}

