/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;

public class PackageFileUtil {
    public static Path generateFolder(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        return path;
    }

    public static void writeFile(Path folder, String name, String content) throws IOException {
        Path file = PackageFileUtil.generateFile(folder, name);
        Files.write(file, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static Path generateFile(Path folder, String name) throws IOException {
        Path path = Paths.get(folder.toString(), name);
        Files.deleteIfExists(path);
        return Files.createFile(path, new FileAttribute[0]);
    }

    public static void deleteFolder(Path pageFolder) throws IOException {
        if (Files.exists(pageFolder, new LinkOption[0])) {
            Files.walk(pageFolder, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }
}

