/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.tasks.model.Assignable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AssignableActivity
extends Activity
implements Assignable {
    private List<Assignment> assignments;

    public abstract String getName();

    protected AssignableActivity() {
    }

    protected AssignableActivity(String user, Date date) {
        super(user, date);
        this.assignments = new ArrayList<Assignment>();
    }

    @Override
    public void assign(Assignment assignment) {
        assignment.syncDueDateTime();
        this.addAssignment(assignment);
    }

    @Override
    public void addAssignment(Assignment assignment) {
        this.assignments.add(assignment);
    }

    public Assignment getLastAssignment() {
        if (!this.isAssigned()) {
            return null;
        }
        return this.assignments.get(this.assignments.size() - 1);
    }

    public boolean isAssigned() {
        return !this.assignments.isEmpty();
    }

    public void setAssignments(List<Assignment> assignments) {
        this.assignments = assignments;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssignableActivity)) {
            return false;
        }
        AssignableActivity other = (AssignableActivity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Assignment> this$assignments = this.getAssignments();
        List<Assignment> other$assignments = other.getAssignments();
        return !(this$assignments == null ? other$assignments != null : !((Object)this$assignments).equals(other$assignments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssignableActivity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Assignment> $assignments = this.getAssignments();
        result = result * 59 + ($assignments == null ? 43 : ((Object)$assignments).hashCode());
        return result;
    }
}

