/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.plugin;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.plugin.ComalaSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PluginSettingsService
implements ComalaSettingsService {
    private static final Logger log = LoggerFactory.getLogger(PluginSettingsService.class);
    private final PluginSettingsFactory pluginSettingsFactory;
    private final WorkflowsFeatureManager workflowsFeatureManager;

    public PluginSettingsService(@ComponentImport PluginSettingsFactory pluginSettingsFactory, WorkflowsFeatureManager workflowsFeatureManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    @Override
    public void addSetting(String key, String value) {
        PluginSettings settings = this.pluginSettingsFactory.createSettingsForKey(this.workflowsFeatureManager.getPluginKey());
        if (settings != null) {
            settings.put(key, (Object)value);
        } else {
            log.warn("Could not be added the addon setting {} with value {}", (Object)key, (Object)value);
        }
    }

    @Override
    public String getSetting(String key) {
        PluginSettings settings = this.pluginSettingsFactory.createSettingsForKey(this.workflowsFeatureManager.getPluginKey());
        if (settings == null) {
            log.error("Plugin settings component is not available");
            return null;
        }
        return (String)settings.get(key);
    }
}

