/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc;

import com.atlassian.confluence.event.events.plugin.PluginFrameworkStartedEvent;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.comalatech.confluence.util.WorkflowsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowReporterBugFixer
extends WorkflowsListener {
    private static final Logger log = LoggerFactory.getLogger(WorkflowReporterBugFixer.class);
    public static final Long HARDCODED_STATES_ID = Long.MAX_VALUE;
    private final WikiStyleRenderer wikiStyleRenderer;

    public WorkflowReporterBugFixer(@ComponentImport WikiStyleRenderer wikiStyleRenderer, @ComponentImport EventPublisher eventPublisher) {
        super(eventPublisher);
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    @EventListener
    public void onPluginEnabledEvent(PluginEnabledEvent event) {
        if ("net.customware.confluence.plugin.reporting".equals(event.getPlugin().getKey())) {
            this.workflowReportingFix();
        }
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.workflowReportingFix();
    }

    protected void workflowReportingFix() {
        try {
            log.info("Validate Workflows-Reporting Classpath");
            Page page = new Page();
            page.setId(HARDCODED_STATES_ID.longValue());
            PageContext pageContext = page.toPageContext();
            String content = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, "{report-table:class=any}\n{local-reporter:workflow:states > all}{local-reporter}\n{report-column:title=Version}{report-info:version}{report-column}\n{report-table}");
            if (log.isDebugEnabled()) {
                log.debug("classpath validation report content post render: " + content);
            }
        }
        catch (Exception ex) {
            log.error("Error in Workflows-Reporting classpath validation, Workflows integration with reporting plugin may not work as expected", (Throwable)ex);
        }
    }
}

