/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.documentActivity.service.DocumentActivityService;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryScope;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityResult;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQueryFilter;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowreports.CsvExportService;
import com.comalatech.confluence.workflowreports.pageactivity.DocActivityCsvServiceImpl;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvConfig;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentActivityExportAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(DocumentActivityExportAction.class);
    private long pageId;
    private String type = "csv";
    private String reportFilePath;
    private AbstractPage page;
    private String outputText;
    @ComponentImport
    private PageManager pageManager;
    private WorkflowPermissionManager workflowPermissionManager;
    private PageActivityCsvService pageActivityCsvService;
    private CsvExportService csvExportService;
    private DocumentActivityService documentActivityService;

    public String execute() throws Exception {
        this.page = this.pageManager.getAbstractPage(this.pageId);
        if (this.page == null || !this.workflowPermissionManager.canViewDrafts(this.page, AuthenticatedUserThreadLocal.get())) {
            return "error";
        }
        InternalDocumentActivityQuery query = new InternalDocumentActivityQuery();
        InternalDocumentActivityQueryFilter filter = new InternalDocumentActivityQueryFilter();
        filter.setScope(DocumentActivityQueryScope.createScopePage(this.pageId));
        query.setFilters(filter);
        DocumentActivityResult result = this.documentActivityService.get(query);
        this.outputText = this.pageActivityCsvService.getPageActivityFileContent(result.getActivities(), this.page, PageActivityCsvConfig.builder().skipOtherVersion(false).build());
        if (this.type.equals("csvtext")) {
            return "csvtext";
        }
        this.reportFilePath = this.csvExportService.export(this.outputText, this.page);
        log.debug("Generated page workflow csv report: " + this.reportFilePath);
        return "success";
    }

    public String getOutputText() {
        return this.outputText;
    }

    public String getReportFilePath() {
        return this.reportFilePath;
    }

    @ParameterSafe
    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    @ParameterSafe
    public void setType(String type) {
        this.type = type;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setWorkflowPermissionManager(WorkflowPermissionManager workflowPermissionManager) {
        this.workflowPermissionManager = workflowPermissionManager;
    }

    public void setDocumentActivityService(DocumentActivityService documentActivityService) {
        this.documentActivityService = documentActivityService;
    }

    public void setPageActivityCsvService(DocActivityCsvServiceImpl pageActivityCsvService) {
        this.pageActivityCsvService = pageActivityCsvService;
    }

    public void setCsvExportService(CsvExportService csvExportService) {
        this.csvExportService = csvExportService;
    }
}

