/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.mappers.csvreport;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.csvactivity.CsvActivity;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.esignatures.model.ESignatureCredentials;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.model.ActivityEntry;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.model.ApprovalActivity;
import com.comalatech.confluence.workflowreports.model.CommentActivity;
import com.comalatech.confluence.workflowreports.model.ModificationActivity;
import com.comalatech.confluence.workflowreports.model.ReadAckActivity;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityEntryProcessor;
import com.comalatech.workflow.model.Assignment;
import com.comalatech.workflow.model.SignatureType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class CsvEntryMapper {
    private final ReportDateFormatter dateFormatter;
    private final I18nResolver i18nResolver;
    private final UserAccessor userAccessor;

    public CsvEntryMapper(ReportDateFormatter dateFormatter, I18nResolver i18nResolver, UserAccessor userAccessor) {
        this.dateFormatter = dateFormatter;
        this.i18nResolver = i18nResolver;
        this.userAccessor = userAccessor;
    }

    public List<CsvActivity> map(List<ActivityReportEntry> activityReportEntry) {
        ArrayList<CsvActivity> csvActivities = new ArrayList<CsvActivity>();
        if (activityReportEntry == null || activityReportEntry.isEmpty()) {
            return csvActivities;
        }
        for (ActivityReportEntry entry : activityReportEntry) {
            List<ActivityEntry> activityEntries = entry.getActivityEntries();
            for (ActivityEntry activityEntry : activityEntries) {
                List<Activity> activities = activityEntry.getActivities();
                Collections.reverse(activities);
                for (Activity activity : activities) {
                    List<String> contributors;
                    CsvActivity csvActivity = new CsvActivity();
                    String formattedDate = this.dateFormatter.formatServerDateTimePrecise(activity.getDate());
                    csvActivity.setDate(formattedDate);
                    String username = activity.getPerformer();
                    if (username == null) {
                        csvActivity.setUser(this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.report.csvexport.anonymous"));
                    } else {
                        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(username);
                        if (confluenceUser != null) {
                            csvActivity.setUser(confluenceUser.getKey().getStringValue());
                        } else {
                            csvActivity.setUser(username);
                        }
                    }
                    if (activity instanceof ModificationActivity && (contributors = ((ModificationActivity)activity).getContributorsUsernames()) != null && !contributors.isEmpty()) {
                        ArrayList<String> users = new ArrayList<String>();
                        for (String contributor : contributors) {
                            if (contributor == null || contributor.isEmpty()) continue;
                            ConfluenceUser confluenceUser = this.userAccessor.getUserByName(contributor);
                            if (confluenceUser != null) {
                                users.add(confluenceUser.getKey().getStringValue());
                                continue;
                            }
                            users.add(contributor);
                        }
                        csvActivity.setContributors(users);
                    }
                    CsvActivity.CsvActivityDescription csvActivityDescription = new CsvActivity.CsvActivityDescription();
                    csvActivityDescription.setText(this.getDescription(activity, activityEntry));
                    csvActivityDescription.setUsers(this.getDescriptionUsers(activity, activityEntry));
                    csvActivity.setDescription(csvActivityDescription);
                    if (activityEntry.getPageState() != null) {
                        csvActivity.setState(activityEntry.getPageState().getName());
                    }
                    csvActivity.setVersion(this.getVersionContent(activityEntry, activity));
                    csvActivity.setComment(this.getComment(activity));
                    csvActivity.setType(activity.getActivityKey());
                    csvActivities.add(csvActivity);
                }
            }
        }
        CsvEntryMapper.sortByDateDesc(csvActivities);
        return csvActivities;
    }

    private static void sortByDateDesc(List<CsvActivity> csvActivities) {
        csvActivities.sort(Comparator.comparing(csvActivity -> TimerUtils.parseDateMultipleFormats(csvActivity.getDate()).toInstant().toEpochMilli(), Comparator.reverseOrder()));
    }

    private String getVersionContent(ActivityEntry activityEntry, Activity activity) {
        Integer version = this.getVersion(activityEntry, activity);
        Object versionStr = "";
        if (version != null) {
            versionStr = "v" + version;
        }
        return versionStr;
    }

    private Integer getVersion(ActivityEntry activityEntry, Activity activity) {
        Integer version = null;
        if (activity instanceof ModificationActivity) {
            version = ((ModificationActivity)activity).getVersion();
        } else if (activity instanceof ApprovalActivity) {
            version = activityEntry.getApprovalCheck().getVersion();
        } else if (activity instanceof ReadAckActivity) {
            version = ((ReadAckActivity)activity).getVersion();
        } else if (activityEntry.getPageState() != null) {
            version = activityEntry.getPageState().getContentVersion();
        } else if (activityEntry.getApprovalCheck() != null) {
            version = activityEntry.getApprovalCheck().getVersion();
        }
        return version;
    }

    private String getComment(Activity activity) {
        if (activity.getComment() != null && !activity.getComment().trim().isEmpty()) {
            return PageActivityEntryProcessor.removeHtmlTags(activity.getComment());
        }
        if ("state".equals(activity.getActivityKey())) {
            PageState pageState = (PageState)activity;
            if (pageState.getStateChangeReason() != null) {
                return this.i18nResolver.getText(Locale.UK, pageState.getStateChangeReason().getI18nName());
            }
            return "";
        }
        return "";
    }

    private String getDescription(Activity activity, ActivityEntry activityEntry) {
        String description;
        switch (activity.getActivityKey()) {
            case "approval": {
                description = this.getApprovalDescription(activity);
                break;
            }
            case "approval-assignment": {
                description = this.getApprovalAssignmentDescription(activity, activityEntry);
                break;
            }
            case "approval-unassignment": {
                description = this.getApprovalUnassignmentDescription(activity, activityEntry);
                break;
            }
            case "assignment": {
                description = this.getTaskAssignmentDescription(activity, activityEntry);
                break;
            }
            case "comment": {
                description = this.getCommentDescription(activity);
                break;
            }
            case "completion": {
                description = this.getCompletionDescription(activity, activityEntry);
                break;
            }
            case "deletion": {
                description = this.getDeletionDescription(activity, activityEntry);
                break;
            }
            case "duedaterecord": {
                description = this.getDueDateRecordDescription(activity, activityEntry);
                break;
            }
            case "duedaterecordexpiry": {
                description = this.getDueDateRecordExpiryDescription(activityEntry);
                break;
            }
            case "modification": {
                description = this.getModificationDescription(activity);
                break;
            }
            case "read-ack": {
                description = this.getReadAckDescription(activity);
                break;
            }
            case "state": {
                description = this.getStateDescription(activity);
                break;
            }
            case "task": {
                description = this.getTaskDescription(activity);
                break;
            }
            default: {
                description = "";
            }
        }
        return PageActivityEntryProcessor.removeHtmlTags(description);
    }

    private List<String> getDescriptionUsers(Activity activity, ActivityEntry activityEntry) {
        ArrayList<String> users = new ArrayList<String>();
        switch (activity.getActivityKey()) {
            case "approval-assignment": {
                String userAssigned = this.getApprovalAssignmentUser(activity);
                if (userAssigned == null) break;
                users.add(userAssigned);
                break;
            }
            case "approval-unassignment": {
                String userUnassigned = this.getApprovalUnassignmentUser(activity);
                if (userUnassigned == null) break;
                users.add(userUnassigned);
                break;
            }
            case "assignment": {
                String taskAssignedUser = this.getTaskAssignmentUser(activity);
                if (taskAssignedUser == null) break;
                users.add(taskAssignedUser);
                break;
            }
            case "state": {
                String stateUser = this.getStateUser(activity);
                if (stateUser == null) break;
                users.add(stateUser);
                break;
            }
            case "task": {
                List<String> taskUsers = this.getTaskUsers(activity, activityEntry);
                if (taskUsers == null) break;
                users.addAll(taskUsers);
                break;
            }
        }
        return users;
    }

    private String getApprovalDescription(Activity activity) {
        ApprovalActivity approvalActivity = (ApprovalActivity)activity;
        String roleName = approvalActivity.getApprover().getRole();
        if (!approvalActivity.getApprover().isApproved()) {
            if (roleName != null && roleName.length() > 0) {
                return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.approval.rejected.role", (Serializable[])new String[]{approvalActivity.getApprovalCheck().getName(), this.getSignatureMode(approvalActivity), roleName});
            }
            return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.approval.rejected", (Serializable[])new String[]{approvalActivity.getApprovalCheck().getName(), this.getSignatureMode(approvalActivity)});
        }
        if (roleName != null && roleName.length() > 0) {
            return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.approval.approved.role", (Serializable[])new String[]{approvalActivity.getApprovalCheck().getName(), this.getSignatureMode(approvalActivity), roleName});
        }
        return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.approval.approved", (Serializable[])new String[]{approvalActivity.getApprovalCheck().getName(), this.getSignatureMode(approvalActivity)});
    }

    private String getApprovalAssignmentDescription(Activity activity, ActivityEntry activityEntry) {
        com.comalatech.confluence.states.model.Assignment approvalAssignment = (com.comalatech.confluence.states.model.Assignment)activity;
        if (approvalAssignment.getRolename() != null && approvalAssignment.getRolename().length() > 0) {
            return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.approval.assigned.role", (Serializable[])new String[]{activityEntry.getApprovalCheck().getName(), "{0}", approvalAssignment.getRolename()});
        }
        return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.approval.assigned", (Serializable[])new String[]{activityEntry.getApprovalCheck().getName(), "{0}"});
    }

    private String getApprovalAssignmentUser(Activity activity) {
        com.comalatech.confluence.states.model.Assignment approvalAssignment = (com.comalatech.confluence.states.model.Assignment)activity;
        String assignee = approvalAssignment.getAssignee();
        if (assignee == null || assignee.isEmpty()) {
            return null;
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(assignee);
        if (confluenceUser != null) {
            return confluenceUser.getKey().toString();
        }
        return assignee;
    }

    private String getApprovalUnassignmentDescription(Activity activity, ActivityEntry activityEntry) {
        Assignment assignment = (Assignment)((Object)activity);
        return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.approval.unassigned", (Serializable[])new String[]{activityEntry.getApprovalCheck().getName(), "{0}"});
    }

    private String getApprovalUnassignmentUser(Activity activity) {
        Assignment assignment = (Assignment)((Object)activity);
        String unassignee = assignment.getAssignee();
        if (unassignee == null || unassignee.isEmpty()) {
            return null;
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(unassignee);
        if (confluenceUser != null) {
            return confluenceUser.getKey().toString();
        }
        return unassignee;
    }

    private String getTaskAssignmentDescription(Activity activity, ActivityEntry activityEntry) {
        String name = "'" + activityEntry.getPageTask().getName() + "'";
        com.comalatech.confluence.states.model.Assignment assignment = (com.comalatech.confluence.states.model.Assignment)activity;
        if (assignment.getAssignee() != null && !assignment.getAssignee().isEmpty()) {
            return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.task.assigned", (Serializable[])new String[]{name, "{0}"});
        }
        return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.task.unassigned", (Serializable[])new String[]{name});
    }

    private String getTaskAssignmentUser(Activity activity) {
        com.comalatech.confluence.states.model.Assignment assignment = (com.comalatech.confluence.states.model.Assignment)activity;
        String assignee = assignment.getAssignee();
        if (assignee == null || assignee.isEmpty()) {
            return null;
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(assignee);
        if (confluenceUser != null) {
            return confluenceUser.getKey().toString();
        }
        return assignee;
    }

    private String getDueDateRecordDescription(Activity activity, ActivityEntry activityEntry) {
        DueDateRecord dueDateRecord = (DueDateRecord)activity;
        if (activityEntry.getPageTask() != null) {
            String pageTaskName = "'" + activityEntry.getPageTask().getName() + "'";
            if (dueDateRecord.getDueDate() != null) {
                return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.dueDateRecord.task", (Serializable[])new String[]{pageTaskName, this.dateFormatter.formatExpiryDateTime(dueDateRecord.getDueDate())});
            }
            return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.dueDateRecord.task.remove", (Serializable[])new String[]{pageTaskName});
        }
        if (activityEntry.getApprovalCheck() != null) {
            if (dueDateRecord.getDueDate() != null) {
                return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.dueDateRecord.approval", (Serializable[])new String[]{activityEntry.getApprovalCheck().getName(), this.dateFormatter.formatExpiryDateTime(dueDateRecord.getDueDate())});
            }
            return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.dueDateRecord.approval.remove", (Serializable[])new String[]{activityEntry.getApprovalCheck().getName()});
        }
        if (dueDateRecord.getDueDate() != null) {
            return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.dueDateRecord.state", (Serializable[])new String[]{activityEntry.getPageState().getName(), this.dateFormatter.formatExpiryDateTime(dueDateRecord.getDueDate())});
        }
        return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.dueDateRecord.state.remove", (Serializable[])new String[]{activityEntry.getPageState().getName()});
    }

    private String getStateDescription(Activity activity) {
        PageState pageState = (PageState)activity;
        StringBuilder description = new StringBuilder();
        if (pageState.getLastAssignment() != null) {
            description.append(this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.changed-state.assigned", (Serializable[])new String[]{pageState.getState(), "{0}"}));
        } else {
            description.append(this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.changed-state", (Serializable[])new String[]{pageState.getState()}));
        }
        if (pageState.getStateChangeReason() != null) {
            description.append(" (").append(this.i18nResolver.getText(Locale.UK, pageState.getStateChangeReason().getI18nName())).append(")");
        }
        return description.toString();
    }

    private String getStateUser(Activity activity) {
        PageState pageState = (PageState)activity;
        if (pageState.getLastAssignment() != null) {
            String assignee = ((com.comalatech.confluence.states.model.Assignment)pageState.getLastAssignment()).getAssignee();
            if (assignee == null || assignee.isEmpty()) {
                return null;
            }
            ConfluenceUser confluenceUser = this.userAccessor.getUserByName(assignee);
            if (confluenceUser != null) {
                return confluenceUser.getKey().toString();
            }
            return assignee;
        }
        return null;
    }

    private String getModificationDescription(Activity activity) {
        ModificationActivity modification = (ModificationActivity)activity;
        if (modification.isCreation()) {
            return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.created");
        }
        return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.modified");
    }

    private String getTaskDescription(Activity activity) {
        PageTask pageTask = (PageTask)activity;
        String taskName = "'" + pageTask.getName() + "'";
        if (pageTask.getType().isQuestion()) {
            return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.task.question-asked", (Serializable[])new String[]{taskName, "{0}"});
        }
        return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.task.created", (Serializable[])new String[]{taskName});
    }

    private List<String> getTaskUsers(Activity activity, ActivityEntry activityEntry) {
        PageTask pageTask = (PageTask)activity;
        if (pageTask.getType().isQuestion()) {
            List<String> users = activityEntry.getActivityUsers();
            ArrayList<String> userKeys = new ArrayList<String>();
            if (users != null && !users.isEmpty()) {
                for (String username : users) {
                    if (username == null || username.isEmpty()) continue;
                    ConfluenceUser confluenceUser = this.userAccessor.getUserByName(username);
                    if (confluenceUser != null) {
                        userKeys.add(confluenceUser.getKey().toString());
                        continue;
                    }
                    userKeys.add(username);
                }
            }
            return userKeys;
        }
        return null;
    }

    private String getDueDateRecordExpiryDescription(ActivityEntry activityEntry) {
        if (activityEntry.getPageTask() != null) {
            String pageTaskName = "'" + activityEntry.getPageTask().getName() + "'";
            return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.report.dueDateRecord.task.expired", (Serializable[])new String[]{pageTaskName});
        }
        return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.report.dueDateRecord.approval.expired", (Serializable[])new String[]{activityEntry.getApprovalCheck().getName()});
    }

    private String getCompletionDescription(Activity activity, ActivityEntry activityEntry) {
        TaskCompletion taskCompletion = (TaskCompletion)activity;
        PageTask pageTask = activityEntry.getPageTask();
        return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.task.completed", (Serializable[])new String[]{"'" + pageTask.getName() + "'"});
    }

    private String getCommentDescription(Activity activity) {
        CommentActivity commentActivity = (CommentActivity)activity;
        return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.task.commented");
    }

    private String getReadAckDescription(Activity activity) {
        return this.i18nResolver.getText(Locale.UK, "readack.activity.migration.report.confirmed.description");
    }

    private String getDeletionDescription(Activity activity, ActivityEntry activityEntry) {
        return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.migration.report.task.deleted", (Serializable[])new String[]{"'" + activityEntry.getPageTask().getName() + "'"});
    }

    public String getSignatureMode(ApprovalActivity approvalActivity) {
        Approver approver = approvalActivity.getApprover();
        String signatureMode = "";
        if (Objects.isNull(approver)) {
            return "";
        }
        if (ESignatureCredentials.Credentials.CONFLUENCE.equals((Object)approver.getESignature())) {
            signatureMode = this.getConfluenceSignatureMode(approver.getSignatureType());
        } else if (ESignatureCredentials.Credentials.OTP.equals((Object)approver.getESignature())) {
            signatureMode = this.getOTPSignatureMode(approver.getSignatureType());
        }
        return signatureMode;
    }

    private String getConfluenceSignatureMode(SignatureType signatureType) {
        switch (signatureType) {
            case PASSWORD: {
                return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.report.approval.esig.password");
            }
            case USERID_AND_PASSWORD: {
                return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.report.approval.esig.user");
            }
        }
        return "";
    }

    private String getOTPSignatureMode(SignatureType signatureType) {
        switch (signatureType) {
            case PASSWORD: {
                return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.report.approval.esig.otp.password");
            }
            case USERID_AND_PASSWORD: {
                return this.i18nResolver.getText(Locale.UK, "com.comalatech.activity.report.approval.esig.otp.user");
            }
        }
        return "";
    }
}

