/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.accessor;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.accessor.CloudMigrationAccessor;
import com.comalatech.confluence.cloud.migration.tasks.AttachActivityTaskRecord;
import com.comalatech.confluence.cloud.migration.tasks.MigrationTaskRecord;
import com.comalatech.confluence.cloud.migration.tasks.MigrationTaskStatus;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AttachActivityAccessor
implements CloudMigrationAccessor {
    private static final Logger log = LoggerFactory.getLogger(AttachActivityAccessor.class);
    private static final String ATTACH_CSV_KEY_PER_PAGE = "com.comalatech.workflows.attach.csv";
    private static final String ATTACH_CSV_KEY_PER_SPACE = "com.comalatech.workflows.attach.csv.per.space";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final BandanaManager bandanaManager;

    public AttachActivityAccessor(@ComponentImport BandanaManager bandanaManager) {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.bandanaManager = bandanaManager;
    }

    @Override
    public MigrationTaskRecord getMigrationTaskStatus(String spaceKey, boolean isPerSpace) {
        String val = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), isPerSpace ? ATTACH_CSV_KEY_PER_SPACE : ATTACH_CSV_KEY_PER_PAGE);
        if (val != null && !val.isEmpty()) {
            try {
                return this.objectMapper.readValue(val, AttachActivityTaskRecord.class);
            }
            catch (IOException e) {
                log.error("Error deserialising AttachActivityTaskRecord", (Throwable)e);
            }
        }
        AttachActivityTaskRecord record = new AttachActivityTaskRecord();
        record.setStatus(MigrationTaskStatus.NOT_RUN);
        return record;
    }

    @Override
    public void setMigrationTaskStatus(String spaceKey, MigrationTaskRecord status, boolean isPerSpace) {
        try {
            this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), isPerSpace ? ATTACH_CSV_KEY_PER_SPACE : ATTACH_CSV_KEY_PER_PAGE, (Object)this.objectMapper.writeValueAsString(status));
        }
        catch (IOException e) {
            log.error("Error serialising AttachActivityTaskRecord", (Throwable)e);
        }
    }
}

