/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.approvals.rest.resources;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.approvals.utils.ApprovalUtils;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.DefaultWorkflowService;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.RestSpaceSettings;
import com.comalatech.confluence.workflow.restv2.resources.AbstractRestResource;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/space")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@PermissionRequired(value={"ADMINISTER"})
public class ApprovalsSpaceAdminResource
extends AbstractRestResource {
    private final WorkflowService workflowService;
    private final Workflow simpleApprovalWorkflow;
    private final String workflowId;

    @Inject
    public ApprovalsSpaceAdminResource() throws WorkflowException {
        this.workflowService = PluginContainerManager.getComponent(WorkflowService.class);
        this.simpleApprovalWorkflow = this.workflowMarkupManager.parseFromWikiMarkup(ApprovalUtils.SIMPLE_APPROVAL_WORKFLOW);
        this.workflowId = DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE, this.simpleApprovalWorkflow);
    }

    @Autowired
    public ApprovalsSpaceAdminResource(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PageManager pageManager, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager, WorkflowService workflowService, ComalaI18nBean comalaI18nBean) throws WorkflowException {
        super(permissionManager, spaceManager, pageManager, workflowMarkupManager, workflowsFeatureManager, comalaI18nBean);
        this.workflowService = workflowService;
        this.simpleApprovalWorkflow = workflowMarkupManager.parseFromWikiMarkup(ApprovalUtils.SIMPLE_APPROVAL_WORKFLOW);
        this.workflowId = DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE, this.simpleApprovalWorkflow);
    }

    @PUT
    @Path(value="/{spaceKey}/enable")
    public Response enableApproval(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    List<com.comalatech.workflow.model.Workflow> spaceWorkflows = ApprovalsSpaceAdminResource.this.workflowService.getWorkflows(spaceKey);
                    if (spaceWorkflows == null || spaceWorkflows.size() == 0) {
                        ApprovalsSpaceAdminResource.this.workflowService.addSpaceWorkflow(spaceKey, ApprovalUtils.SIMPLE_APPROVAL_WORKFLOW);
                    } else {
                        for (com.comalatech.workflow.model.Workflow workflow : spaceWorkflows) {
                            if ("Simple Approval Workflow".equals(workflow.getName())) {
                                ApprovalsSpaceAdminResource.this.workflowService.activateWorkflow(spaceKey, ApprovalsSpaceAdminResource.this.workflowId);
                                continue;
                            }
                            ApprovalsSpaceAdminResource.this.workflowService.addSpaceWorkflow(spaceKey, ApprovalUtils.SIMPLE_APPROVAL_WORKFLOW);
                        }
                    }
                    return ApprovalsSpaceAdminResource.this.getSpaceApprovalsSettings(spaceKey);
                }
                catch (WorkflowException e) {
                    return ApprovalsSpaceAdminResource.this.handleException(e);
                }
            }
        }.execute();
    }

    @PUT
    @Path(value="/{spaceKey}/disable")
    public Response disableApproval(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    ApprovalsSpaceAdminResource.this.workflowService.deactivateWorkflow(spaceKey, ApprovalsSpaceAdminResource.this.workflowId);
                    return ApprovalsSpaceAdminResource.this.getSpaceApprovalsSettings(spaceKey);
                }
                catch (Exception e) {
                    return ApprovalsSpaceAdminResource.this.handleException(e);
                }
            }
        }.execute();
    }

    @GET
    @Path(value="/{spaceKey}/settings")
    public Response getSpaceApprovalsSettings(final @PathParam(value="spaceKey") String spaceKey) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                RestSpaceSettings spaceSettings = new RestSpaceSettings(ApprovalsSpaceAdminResource.this.isApprovalsEnabled(spaceKey), "Simple Approval Workflow", StringUtils.join((Object[])ApprovalUtils.States.values(), (String)","), "A Simple Approval Workflow, a page's state can be for 'Review', 'Approved' or 'Rejected'. Only 'Approved' pages are visible to Read-only users.");
                return Response.ok().entity((Object)spaceSettings).build();
            }
        }.execute();
    }

    private boolean isApprovalsEnabled(String spaceKey) {
        List<com.comalatech.workflow.model.Workflow> spaceWorkflows = this.workflowService.getWorkflows(spaceKey);
        for (com.comalatech.workflow.model.Workflow workflow : spaceWorkflows) {
            if (!workflow.getName().equals("Simple Approval Workflow") || !workflow.isActive()) continue;
            return true;
        }
        return false;
    }
}

