/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.param.criteria.content;

import com.atlassian.confluence.core.ListQuery;
import java.util.ArrayList;
import java.util.List;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;
import org.randombits.confluence.filtering.criteria.content.ContentTypeCriterion;
import org.randombits.confluence.filtering.param.ListQueryParameter;
import org.randombits.confluence.filtering.param.ParameterException;
import org.randombits.confluence.filtering.param.criteria.CriterionParameter;
import org.randombits.confluence.support.MacroInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentTypeParameter
extends CriterionParameter
implements ListQueryParameter<Criterion> {
    private static final List<String> TYPES = new ArrayList<String>();

    public ContentTypeParameter() {
        this(null);
    }

    public ContentTypeParameter(String defaultValue) {
        super(defaultValue, "type", "types");
    }

    @Override
    protected CriterionInterpreter createCriterionInterpreter(MacroInfo info) {
        return new ContentTypeCriterion.Interpeter();
    }

    @Override
    public void prepareListQuery(ListQuery listQuery, MacroInfo info) throws ParameterException {
        Criterion criterion = this.createCriterion(info);
        if (criterion != null) {
            ArrayList<String> types = new ArrayList<String>();
            for (String type : TYPES) {
                if (!criterion.matches(type)) continue;
                types.add(type);
            }
            listQuery.setTypeList(types);
        }
    }

    static {
        TYPES.add("page");
        TYPES.add("blogpost");
        TYPES.add("blogpost");
        TYPES.add("spacedesc");
        TYPES.add("comment");
        TYPES.add("attachment");
        TYPES.add("mail");
        TYPES.add("space");
        TYPES.add("mailto");
        TYPES.add("url");
        TYPES.add("unresolved");
    }
}

