/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.user;

import com.atlassian.user.User;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.randombits.confluence.filtering.criteria.SourceCriterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserCriterion
implements SourceCriterion<String> {
    private String username;

    public UserCriterion(User user) {
        this.username = user == null ? null : user.getName();
    }

    public UserCriterion(String username) {
        this.username = username;
    }

    @Override
    public boolean matches(Object object) {
        String match = null;
        if (object instanceof User) {
            match = ((User)object).getName();
        } else if (object instanceof String) {
            match = (String)object;
        }
        return StringUtils.equals((String)this.username, (String)match);
    }

    @Override
    public Collection<String> getMatchingValues() {
        return Arrays.asList(this.username);
    }

    public String toString() {
        return "{username: " + (this.username == null ? "anonymous" : this.username) + "}";
    }

    @Override
    public SourceCriterion.Weight getWeight() {
        return SourceCriterion.Weight.LIGHT;
    }
}

