/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhocworkflows.rest.AbstractAdhocResources;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflowsRepository;
import com.comalatech.confluence.workflowcontainer.rest.RemoteRepositoryRestModel;
import com.comalatech.workflow.WorkflowHandler;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@WorkflowsAppRequired
@Path(value="/remote")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RemoteRepositoryResources
extends AbstractAdhocResources {
    protected final WorkflowContainerManager workflowContainerManager;

    @Inject
    public RemoteRepositoryResources() {
        this.workflowContainerManager = PluginContainerManager.getComponent(WorkflowContainerManager.class);
    }

    @Autowired
    public RemoteRepositoryResources(@ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport SpacePermissionManager spacePermissionManager, @ComponentImport AccessModeService accessModeService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowHandler workflowHandler, UserSearchManager userSearchManager, @ComponentImport BootstrapManager bootstrapManager, WorkflowContainerManager workflowContainerManager, ComalaI18nBean comalaI18nBean) {
        super(pageManager, permissionManager, workflowPermissionManager, spaceManager, spacePermissionManager, accessModeService, workflowsFeatureManager, workflowConfigurationManager, workflowHandler, userSearchManager, bootstrapManager, comalaI18nBean);
        this.workflowContainerManager = workflowContainerManager;
    }

    @GET
    @Path(value="/workflows")
    @ApiResponses(value={@ApiResponse(code=200, message="Remote resources")})
    public Response getRemoteWorkflows() {
        RemoteWorkflowsRepository remoteWorkflows = this.workflowContainerManager.getRemoteWorkflows(false);
        return Response.ok((Object)RemoteRepositoryRestModel.buildFrom(this.workflowContainerManager, remoteWorkflows)).build();
    }
}

