/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.mapper;

import com.comalatech.confluence.readack.model.ReadAckContentPropertyModel;
import com.comalatech.confluence.workflow.WorkflowException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadAckContentPropertyModelMapper {
    private static final Logger log = LoggerFactory.getLogger(ReadAckContentPropertyModelMapper.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static ReadAckContentPropertyModel map(String json) throws WorkflowException {
        try {
            return mapper.readValue(json, ReadAckContentPropertyModel.class);
        }
        catch (IOException | NullPointerException e) {
            log.error("ReadAckContentPropertyModel could not be serialized", (Throwable)e);
            throw new WorkflowException(e);
        }
    }

    public static String map(ReadAckContentPropertyModel data) throws WorkflowException {
        try {
            return mapper.writeValueAsString(data);
        }
        catch (Exception e) {
            log.error("ReadAckContentPropertyModel could not be serializated", (Throwable)e);
            return null;
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        mapper.setDateFormat(df);
    }
}

