/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@ApiModel(description="Object with the target page/s id/s or space/s key/s to search activities for. It should refer only to one of them depending on which endpoint is been called.If the endpoint called is the page's one, only the pageIds should be provided, and vice-versa.")
public class DocumentActivityQueryScope {
    @ApiModelProperty(value="List with the page Ids", example="[\"134325\", \"24362345\", \"2345643\"]")
    List<Long> pageIds;
    @ApiModelProperty(value="List with the space keys", example="[\"ADC\", \"SWP\", \"COM\"]")
    List<String> spaceKeys;

    private DocumentActivityQueryScope(List<Long> pageIds, List<String> spaceKeys) {
        this.pageIds = pageIds;
        this.spaceKeys = spaceKeys;
    }

    public static DocumentActivityQueryScope createScopePages(List<Long> pageIds) {
        return new DocumentActivityQueryScope(pageIds, null);
    }

    public static DocumentActivityQueryScope createScopeSpaces(List<String> spaceKeys) {
        return new DocumentActivityQueryScope(null, spaceKeys);
    }

    public static DocumentActivityQueryScope createScopePage(Long pageId) {
        return new DocumentActivityQueryScope(Collections.singletonList(pageId), null);
    }

    public static DocumentActivityQueryScopeBuilder builder() {
        return new DocumentActivityQueryScopeBuilder();
    }

    public List<Long> getPageIds() {
        return this.pageIds;
    }

    public List<String> getSpaceKeys() {
        return this.spaceKeys;
    }

    public void setPageIds(List<Long> pageIds) {
        this.pageIds = pageIds;
    }

    public void setSpaceKeys(List<String> spaceKeys) {
        this.spaceKeys = spaceKeys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentActivityQueryScope)) {
            return false;
        }
        DocumentActivityQueryScope other = (DocumentActivityQueryScope)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Long> this$pageIds = this.getPageIds();
        List<Long> other$pageIds = other.getPageIds();
        if (this$pageIds == null ? other$pageIds != null : !((Object)this$pageIds).equals(other$pageIds)) {
            return false;
        }
        List<String> this$spaceKeys = this.getSpaceKeys();
        List<String> other$spaceKeys = other.getSpaceKeys();
        return !(this$spaceKeys == null ? other$spaceKeys != null : !((Object)this$spaceKeys).equals(other$spaceKeys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentActivityQueryScope;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Long> $pageIds = this.getPageIds();
        result = result * 59 + ($pageIds == null ? 43 : ((Object)$pageIds).hashCode());
        List<String> $spaceKeys = this.getSpaceKeys();
        result = result * 59 + ($spaceKeys == null ? 43 : ((Object)$spaceKeys).hashCode());
        return result;
    }

    public String toString() {
        return "DocumentActivityQueryScope(pageIds=" + this.getPageIds() + ", spaceKeys=" + this.getSpaceKeys() + ")";
    }

    public DocumentActivityQueryScope() {
    }

    public static class DocumentActivityQueryScopeBuilder {
        private List<Long> pageIds;
        private List<String> spaceKeys;

        DocumentActivityQueryScopeBuilder() {
        }

        public DocumentActivityQueryScopeBuilder pageIds(List<Long> pageIds) {
            this.pageIds = pageIds;
            return this;
        }

        public DocumentActivityQueryScopeBuilder spaceKeys(List<String> spaceKeys) {
            this.spaceKeys = spaceKeys;
            return this;
        }

        public DocumentActivityQueryScope build() {
            return new DocumentActivityQueryScope(this.pageIds, this.spaceKeys);
        }

        public String toString() {
            return "DocumentActivityQueryScope.DocumentActivityQueryScopeBuilder(pageIds=" + this.pageIds + ", spaceKeys=" + this.spaceKeys + ")";
        }
    }
}

