/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.manager;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostMovedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalApprovedMapper;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalAssignedMapper;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalRejectedMapper;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalUnassignedMapper;
import com.comalatech.confluence.documentActivity.mapper.readack.ReadAckCompletedMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateClosedMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateDueDateMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateExpiredMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateInitMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateOverrideMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateTransitionMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskAssignmentMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskCompletionMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskCreationMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskDeletionMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskDueDateDeletionMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskDueDateExpiryMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskDueDateMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskUnassignmentMapper;
import com.comalatech.confluence.documentActivity.mapper.task.TaskUpdateMapper;
import com.comalatech.confluence.documentActivity.service.DocumentActivityService;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.workflow.accesor.WorkflowsActivityRecordAccessor;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EventHistoryManager {
    private static final Logger log = LoggerFactory.getLogger(EventHistoryManager.class);
    private final DocumentActivityService documentActivityService;
    private final DocumentActivityUpgradeService documentActivityUpgradeService;
    private final List<EventActivityMapper> mappers;
    private final WorkflowsActivityRecordAccessor workflowsActivityAccessor;
    private static final List<String> REMOVAL_EVENTS = Arrays.asList(PageRemoveEvent.class.getName(), BlogPostRemoveEvent.class.getName());
    private static final List<String> MOVE_EVENTS = Arrays.asList(PageMoveEvent.class.getName(), BlogPostMovedEvent.class.getName());

    public EventHistoryManager(DocumentActivityService documentActivityService, DocumentActivityUpgradeService documentActivityUpgradeService, @ComponentImport UserAccessor userAccessor, WorkflowUserAccessor workflowUserAccessor, WorkflowsActivityRecordAccessor workflowsActivityAccessor) {
        this.documentActivityService = documentActivityService;
        this.documentActivityUpgradeService = documentActivityUpgradeService;
        this.workflowsActivityAccessor = workflowsActivityAccessor;
        ActorUtils actorUtils = new ActorUtils(userAccessor, workflowUserAccessor);
        this.mappers = new ArrayList<EventActivityMapper>();
        this.mappers.add(new ApprovalApprovedMapper(actorUtils));
        this.mappers.add(new ApprovalAssignedMapper(actorUtils));
        this.mappers.add(new ApprovalRejectedMapper(actorUtils));
        this.mappers.add(new ApprovalUnassignedMapper(actorUtils));
        this.mappers.add(new ReadAckCompletedMapper(actorUtils));
        this.mappers.add(new StateDueDateMapper(actorUtils));
        this.mappers.add(new StateExpiredMapper(actorUtils));
        this.mappers.add(new StateInitMapper(actorUtils));
        this.mappers.add(new StateOverrideMapper(actorUtils));
        this.mappers.add(new StateTransitionMapper(actorUtils));
        this.mappers.add(new StateClosedMapper(actorUtils));
        this.mappers.add(new TaskAssignmentMapper(actorUtils));
        this.mappers.add(new TaskCompletionMapper(actorUtils));
        this.mappers.add(new TaskCreationMapper(actorUtils));
        this.mappers.add(new TaskDeletionMapper(actorUtils));
        this.mappers.add(new TaskUnassignmentMapper(actorUtils));
        this.mappers.add(new TaskUpdateMapper(actorUtils));
        this.mappers.add(new TaskDueDateMapper(actorUtils));
        this.mappers.add(new TaskDueDateDeletionMapper(actorUtils));
        this.mappers.add(new TaskDueDateExpiryMapper(actorUtils));
    }

    public void processHistoryEvent(ContentEvent event) {
        block6: {
            try {
                if (REMOVAL_EVENTS.contains(event.getClass().getName())) {
                    this.onContentRemove(event);
                    break block6;
                }
                if (MOVE_EVENTS.contains(event.getClass().getName())) {
                    this.onContentMove(event);
                    break block6;
                }
                for (EventActivityMapper mapper : this.mappers) {
                    Activity activity = mapper.map((ConfluenceEvent)event);
                    if (activity == null) continue;
                    AbstractPage page = (AbstractPage)event.getContent();
                    if (this.documentActivityUpgradeService.hasAlreadyBeenUpgraded(page) || !this.documentActivityService.getById(page).isEmpty()) {
                        this.documentActivityService.create(activity);
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error("There was an error while processing event: " + event, (Throwable)e);
            }
        }
    }

    protected void onContentRemove(ContentEvent event) {
        this.documentActivityService.deleteByContentId(event.getContent().getId());
    }

    protected void onContentMove(ContentEvent event) {
        AbstractPage content = (AbstractPage)event.getContent();
        if (!this.documentActivityService.getById(content).isEmpty()) {
            this.documentActivityService.update(content.getId(), content.getSpace().getId());
            this.documentActivityUpgradeService.isSpaceStatusUpgradeSuccess(content);
        } else {
            boolean targetSpaceIsUpgraded = this.documentActivityUpgradeService.isSpaceStatusUpgradeSuccess(content);
            if (targetSpaceIsUpgraded && this.workflowsActivityAccessor.hasWorkflowActivity(content)) {
                this.documentActivityUpgradeService.markPageAsUpgradePending(content);
            }
        }
    }
}

