/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.MigrationNamesSpaces;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="cloudWorkflowUserIdPopulationUseCase")
public class CloudWorkflowUserIdPopulationUseCase
implements CloudPopulationData<String> {
    private static final Logger log = LoggerFactory.getLogger(CloudWorkflowUserIdPopulationUseCase.class);
    private static final String USER = "user";
    private final UserAccessor userAccessor;
    private final ObjectMapper objectMapper;

    public CloudWorkflowUserIdPopulationUseCase(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public String populateCloudData(String cloudWorkflow, Map<String, String> contentMapping) {
        ObjectNode rootNode;
        if (contentMapping.isEmpty()) {
            return cloudWorkflow;
        }
        try {
            JsonNode triggersNode;
            rootNode = (ObjectNode)this.objectMapper.readTree(cloudWorkflow);
            this.mapParameterCloudIds(contentMapping, rootNode);
            ArrayNode statesNode = (ArrayNode)rootNode.get("states");
            if (!Objects.isNull(statesNode) && statesNode.isArray()) {
                statesNode.forEach(stateNode -> this.mapApprovalsCloudIds(contentMapping, (JsonNode)stateNode));
            }
            if (!Objects.isNull(triggersNode = rootNode.get("triggers")) && triggersNode.isArray()) {
                triggersNode.forEach(triggerNode -> this.mapActionsCloudIds(contentMapping, (JsonNode)triggerNode));
            }
        }
        catch (JsonProcessingException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return rootNode.toString();
    }

    private void mapParameterCloudIds(Map<String, String> userMapping, JsonNode workflowMarkupNode) {
        JsonNode parameters = workflowMarkupNode.get("parameters");
        if (!Objects.nonNull(parameters) || !parameters.isArray()) {
            return;
        }
        for (JsonNode parameter : parameters) {
            if (!USER.equals(parameter.get("type").asText())) continue;
            ObjectNode parameterObject = (ObjectNode)parameter;
            TextNode valueNode = (TextNode)parameter.get("value");
            if (valueNode == null) continue;
            String[] userIds = valueNode.asText().split(",");
            String cloudUserIds = Arrays.stream(userIds).map(String::trim).map(userId -> {
                ConfluenceUser user = this.userAccessor.getUserByName(userId);
                if (user != null) {
                    String mappedUser = (String)userMapping.get(MigrationNamesSpaces.USERS_KEY_PREFIX + user.getKey().getStringValue());
                    return mappedUser != null ? mappedUser : userId;
                }
                return userId;
            }).collect(Collectors.joining(","));
            parameterObject.put("value", cloudUserIds);
        }
    }

    private void mapApprovalsCloudIds(Map<String, String> userMapping, JsonNode stateNode) {
        JsonNode approvals = stateNode.get("approvals");
        if (Objects.isNull(approvals) || !approvals.isArray()) {
            return;
        }
        for (JsonNode approvalNode : approvals) {
            ArrayNode preassignedUsers = Objects.nonNull(approvalNode.get("preassignedUsers")) ? (ArrayNode)approvalNode.get("preassignedUsers").get("items") : null;
            if (Objects.isNull(preassignedUsers) || !preassignedUsers.isArray()) continue;
            for (int i = 0; i < preassignedUsers.size(); ++i) {
                String value = preassignedUsers.get(i).asText();
                ConfluenceUser confluenceUser = this.userAccessor.getUserByName(value);
                if (!Objects.nonNull(confluenceUser) || !Objects.nonNull(userMapping.get(MigrationNamesSpaces.USERS_KEY_PREFIX + confluenceUser.getKey().getStringValue()))) continue;
                preassignedUsers.set(i, userMapping.get(MigrationNamesSpaces.USERS_KEY_PREFIX + confluenceUser.getKey().getStringValue()));
            }
        }
    }

    private void mapActionsCloudIds(Map<String, String> userMapping, JsonNode triggerNode) {
        JsonNode actions = triggerNode.get("actions");
        if (Objects.isNull(actions) || !actions.isArray()) {
            return;
        }
        for (JsonNode actionNode : actions) {
            switch (actionNode.get("action").asText()) {
                case "send-email": {
                    this.mapSendEmailAction(userMapping, (ArrayNode)actionNode.get("recipients"));
                }
                case "add-restrictions": 
                case "set-restrictions": {
                    this.mapRestrictionActions(userMapping, (ArrayNode)actionNode.get("restrictions"));
                }
            }
        }
    }

    private void mapSendEmailAction(Map<String, String> userMapping, ArrayNode recipients) {
        if (Objects.isNull(recipients)) {
            return;
        }
        for (int i = 0; i < recipients.size(); ++i) {
            ConfluenceUser confluenceUser;
            ObjectNode value;
            TextNode userJsonNode;
            if (!(recipients.get(i) instanceof ObjectNode) || !Objects.nonNull(userJsonNode = (TextNode)(value = (ObjectNode)recipients.get(i)).get(USER)) || !Objects.nonNull(confluenceUser = this.userAccessor.getUserByName(userJsonNode.asText()))) continue;
            value.put(USER, userMapping.get(MigrationNamesSpaces.USERS_KEY_PREFIX + confluenceUser.getKey().getStringValue()));
        }
    }

    private void mapRestrictionActions(Map<String, String> userMapping, ArrayNode restrictions) {
        int i;
        if (Objects.isNull(restrictions)) {
            return;
        }
        ArrayNode users = null;
        for (i = 0; i < restrictions.size(); ++i) {
            if (!Objects.nonNull(restrictions.get(i).get(USER))) continue;
            users = (ArrayNode)restrictions.get(i).get(USER);
        }
        if (Objects.isNull(users)) {
            return;
        }
        for (i = 0; i < users.size(); ++i) {
            ConfluenceUser confluenceUser = this.userAccessor.getUserByName(users.get(i).asText());
            if (!Objects.nonNull(confluenceUser)) continue;
            users.set(i, userMapping.get(MigrationNamesSpaces.USERS_KEY_PREFIX + confluenceUser.getKey().getStringValue()));
        }
    }
}

