/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.api.model.content;

import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.util.GeneralUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionConf9Compatibility {
    private static final Logger log = LoggerFactory.getLogger(VersionConf9Compatibility.class);

    public static Date getWhen(Version version) {
        OffsetDateTime createdAtOffset;
        if (GeneralUtil.getVersionNumber().startsWith(String.valueOf(9)) && (createdAtOffset = VersionConf9Compatibility._getWhenAt(version)) != null) {
            return Date.from(createdAtOffset.toInstant());
        }
        try {
            Class<?> dateTimeClass = VersionConf9Compatibility.getConfluenceDateTimeClass();
            Method getWhenMethod = version.getClass().getMethod("getWhen", new Class[0]);
            Object lastModified = getWhenMethod.invoke((Object)version, new Object[0]);
            Object dateTimeInstance = dateTimeClass.cast(lastModified);
            Method toDateMethod = dateTimeClass.getMethod("toDate", new Class[0]);
            return (Date)toDateMethod.invoke(dateTimeInstance, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static OffsetDateTime _getWhenAt(Version version) {
        try {
            Method queryMethod = Version.class.getMethod("getWhenAt", new Class[0]);
            return (OffsetDateTime)queryMethod.invoke((Object)version, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error("Error detected while retrieving getWhenAt through compatibility layer", (Throwable)e);
            return null;
        }
    }

    private static Class<?> getConfluenceDateTimeClass() throws ClassNotFoundException {
        ClassLoader confluenceClassLoader = SearchResult.class.getClassLoader();
        return Class.forName("org.joda.time.DateTime", true, confluenceClassLoader);
    }
}

