/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.task;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.comalatech.confluence.documentActivity.upgrade.utils.SupportPackageFile;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.CSVBuilder;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.confluence.workflow.usage.download.commands.SpaceWorkflowsCSV;
import com.comalatech.confluence.workflow.usage.download.model.SpaceWorkflowsCSVData;
import com.comalatech.confluence.workflow.usage.model.SpaceWorkflowReportEntry;
import com.comalatech.confluence.workflow.usage.service.WorkflowsUsageReportService;
import com.comalatech.confluence.workflow.usage.task.model.Status;
import com.comalatech.confluence.workflow.usage.task.model.WorkflowsUsageTask;
import com.comalatech.confluence.workflow.usage.util.WorkflowsUsagePackageFile;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceWorkflowReportTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(SpaceWorkflowReportTask.class);
    private final SpaceManager spaceManager;
    private final SpaceService spaceService;
    private final WorkflowsUsageReportService workflowsUsageReportService;
    private final ComalaI18nBean comalaI18nBean;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final SpaceWorkflowsCSV spaceWorkflowsCSV;
    private final WorkflowsUsageTask workflowsUsageTask;

    public SpaceWorkflowReportTask(SpaceManager spaceManager, SpaceService spaceService, WorkflowsUsageReportService workflowsUsageReportService, ComalaI18nBean comalaI18nBean, ReadWriteTransactionService readWriteTransactionService, SupportPresenter templateFileLayoutHelper, WorkflowsUsageTask workflowsUsageTask) {
        this.spaceManager = spaceManager;
        this.spaceService = spaceService;
        this.workflowsUsageReportService = workflowsUsageReportService;
        this.comalaI18nBean = comalaI18nBean;
        this.readWriteTransactionService = readWriteTransactionService;
        this.spaceWorkflowsCSV = new SpaceWorkflowsCSV(templateFileLayoutHelper);
        this.workflowsUsageTask = workflowsUsageTask;
    }

    protected void runInternal() {
        Instant startedAt = Instant.now();
        try {
            WorkflowsUsagePackageFile.deleteFolder(WorkflowsUsagePackageFile.getWorkflowsUsageBasePath("space"));
            if (this.isReportTaskReadyToStart()) {
                CSVBuilder csv = new CSVBuilder();
                this.readWriteTransactionService.executeInReadOnlyTransaction(() -> {
                    AtomicLong recordsProcessed = new AtomicLong(0L);
                    this.generateHeaders(csv);
                    this.progress.setStatus(Status.IN_PROGRESS.getValue());
                    Collection activeSpaceKeys = this.spaceManager.getAllSpaceKeys(SpaceStatus.CURRENT);
                    for (String spaceKey : activeSpaceKeys) {
                        Space space = this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetch().orElse(null);
                        if (space != null) {
                            try {
                                List<SpaceWorkflowReportEntry> spaceWorkflowReportEntries = this.workflowsUsageReportService.getSpaceWorkflowsReport(space);
                                if (!spaceWorkflowReportEntries.isEmpty()) {
                                    spaceWorkflowReportEntries.forEach(usageReport -> {
                                        this.addUsageReport(csv, (SpaceWorkflowReportEntry)usageReport);
                                        csv.newLine();
                                    });
                                }
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                                throw new RuntimeException();
                            }
                        }
                        recordsProcessed.incrementAndGet();
                        this.progress.setPercentage(recordsProcessed.intValue() * 90 / activeSpaceKeys.size());
                    }
                    return null;
                });
                this.spaceWorkflowsCSV.generateSupportFile(SpaceWorkflowsCSVData.builder().csv(csv.get()).build(), SupportPackageFile.generateFolder(WorkflowsUsagePackageFile.getWorkflowsUsageBasePath("space")));
            }
            this.progress.setCompletedSuccessfully(true);
            this.progress.setStatus(Status.SUCCESS.getValue());
            this.workflowsUsageTask.setStatus(Status.SUCCESS);
        }
        catch (Exception ex) {
            this.progress.setCompletedSuccessfully(false);
            this.progress.setStatus(Status.FAIL.getValue());
            this.workflowsUsageTask.setStatus(Status.FAIL);
            log.error(ex.getMessage(), (Throwable)ex);
        }
        this.progress.setPercentage(100);
        this.workflowsUsageTask.setDuration(TimerUtils.getDuration(startedAt));
        this.workflowsUsageReportService.saveSpaceWorkflowsUsageReportTask(this.workflowsUsageTask);
    }

    private void generateHeaders(CSVBuilder csv) {
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.spaceworkflows.report.csvexport.spacename.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.spaceworkflows.report.csvexport.spacekey.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.spaceworkflows.report.csvexport.workflowname.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.spaceworkflows.report.csvexport.type.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.spaceworkflows.report.csvexport.labels.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.spaceworkflows.report.csvexport.invertlabels.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.spaceworkflows.report.csvexport.active.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.spaceworkflows.report.csvexport.lastpageupdate.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.spaceworkflows.report.csvexport.totalpagesinworkflow.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.spaceworkflows.report.csvexport.totalpagesinspace.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.spaceworkflows.report.csvexport.markup.header"));
        csv.newLine();
    }

    private void addUsageReport(CSVBuilder csv, SpaceWorkflowReportEntry reportEntry) {
        csv.addCell(reportEntry.getSpaceWorkflowInstance().getSpaceName());
        csv.addCell(reportEntry.getSpaceWorkflowInstance().getSpaceKey());
        csv.addCell(reportEntry.getSpaceWorkflowInstance().getWorkflowName());
        csv.addCell(reportEntry.getWorkflowTypeForCsv());
        csv.addCell(reportEntry.getWorkflowLabels());
        csv.addCell(String.valueOf(reportEntry.getSpaceWorkflowInstance().isInvertLabels()));
        csv.addCell(String.valueOf(reportEntry.getSpaceWorkflowInstance().isActive()));
        csv.addCell(String.valueOf(reportEntry.getLastPageUpdateInSpace()));
        csv.addCell(String.valueOf(reportEntry.getWorkflowPageCount()));
        csv.addCell(String.valueOf(reportEntry.getSpacePageCount()));
        csv.addCell(reportEntry.getSpaceWorkflowInstance().getMarkup());
    }

    private boolean isReportTaskReadyToStart() throws Exception {
        WorkflowsUsageTask storedWorkflowsUsageTask = this.workflowsUsageReportService.getSpaceWorkflowsUsageReportTask();
        LocalDateTime timeLimit = LocalDateTime.now().plusSeconds(180L);
        while (!Status.IN_PROGRESS.equals((Object)storedWorkflowsUsageTask.getStatus()) && TimerUtils.toEpochMilli(LocalDateTime.now()) <= TimerUtils.toEpochMilli(timeLimit)) {
            storedWorkflowsUsageTask = this.workflowsUsageReportService.getSpaceWorkflowsUsageReportTask();
            Thread.sleep(2000L);
        }
        this.workflowsUsageTask.setStartedAt(storedWorkflowsUsageTask.getStartedAt());
        return Status.IN_PROGRESS.equals((Object)storedWorkflowsUsageTask.getStatus());
    }

    public String getName() {
        return "Space workflows report task";
    }
}

