/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.accessor;

import com.comalatech.confluence.plugin.PluginSettingsService;
import com.comalatech.confluence.workflow.usage.accessor.WorkflowsUsageReportAccessor;
import com.comalatech.confluence.workflow.usage.accessor.model.PageWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.accessor.model.SpaceWorkflowReportTaskRecord;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultWorkflowsUsageReportAccessor
implements WorkflowsUsageReportAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowsUsageReportAccessor.class);
    private static final String PAGE_WORKFLOWS_USAGE_KEY = "pageworkflowsusage";
    private static final String SPACE_WORKFLOWS_USAGE_KEY = "spaceworkflowsusage";
    private final PluginSettingsService pluginSettingsService;
    private final ObjectMapper objectMapper;

    public DefaultWorkflowsUsageReportAccessor(PluginSettingsService pluginSettingsService) {
        this.pluginSettingsService = pluginSettingsService;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public PageWorkflowReportTaskRecord getPageWorkflowsReportTaskRecord() {
        String pageWorkflowsUsageSetting = this.pluginSettingsService.getSetting(PAGE_WORKFLOWS_USAGE_KEY);
        if (pageWorkflowsUsageSetting != null) {
            try {
                return this.objectMapper.readValue(pageWorkflowsUsageSetting, PageWorkflowReportTaskRecord.class);
            }
            catch (JsonProcessingException e) {
                log.error("Failed retrieving the PageWorkflowReportTaskRecord from the pluggingSettingsService", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void savePageWorkflowsReportTaskRecord(PageWorkflowReportTaskRecord pageWorkflowReportTaskRecord) {
        try {
            this.pluginSettingsService.addSetting(PAGE_WORKFLOWS_USAGE_KEY, this.objectMapper.writeValueAsString(pageWorkflowReportTaskRecord));
        }
        catch (JsonProcessingException e) {
            log.error("Failed saving the PageWorkflowReportTaskRecord on the pluggingSettingsService", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public SpaceWorkflowReportTaskRecord getSpaceWorkflowsReportTaskRecord() {
        String spaceWorkflowsUsageSetting = this.pluginSettingsService.getSetting(SPACE_WORKFLOWS_USAGE_KEY);
        if (spaceWorkflowsUsageSetting != null) {
            try {
                return this.objectMapper.readValue(spaceWorkflowsUsageSetting, SpaceWorkflowReportTaskRecord.class);
            }
            catch (JsonProcessingException e) {
                log.error("Failed retrieving the SpaceWorkflowReportTaskRecord from the pluggingSettingsService", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void saveSpaceWorkflowsReportTaskRecord(SpaceWorkflowReportTaskRecord spaceWorkflowReportTaskRecord) {
        try {
            this.pluginSettingsService.addSetting(SPACE_WORKFLOWS_USAGE_KEY, this.objectMapper.writeValueAsString(spaceWorkflowReportTaskRecord));
        }
        catch (JsonProcessingException e) {
            log.error("Failed saving the SpaceWorkflowReportTaskRecord on the pluggingSettingsService", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

