/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import org.apache.commons.lang3.StringUtils;

public class PermissionCondition
extends Condition {
    public static final String PERMISSION_EDIT = "edit";
    public static final String PERMISSION_VIEW = "view";
    public static final String PERMISSION_ADMINISTER = "administer";
    public static final String ALL_PERMISSIONS = "edit, view, administer";
    private Permission[] permissions;

    public PermissionCondition(boolean not, String permissionsList) throws WorkflowException {
        super(not);
        this.parsePermissions(permissionsList);
    }

    public Permission[] getPermissions() {
        return this.permissions;
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (valueStore.canAdminWorkflow(user)) {
            return true;
        }
        for (int i = 0; i < this.permissions.length; ++i) {
            AbstractPage permissionTarget = valueStore.getPage();
            if (Permission.ADMINISTER.equals((Object)this.permissions[i])) {
                permissionTarget = valueStore.getPage().getSpace();
            }
            if (this.getPermissionManager().hasPermission((User)user, this.permissions[i], (Object)permissionTarget)) continue;
            return false;
        }
        return true;
    }

    private void parsePermissions(String permissionsList) throws WorkflowException {
        if (!StringUtils.isNotBlank((CharSequence)permissionsList)) {
            throw new WorkflowException("Permissions not defined, must be one of edit, view, administer");
        }
        String[] permissionNames = permissionsList.split(",");
        this.permissions = new Permission[permissionNames.length];
        for (int i = 0; i < permissionNames.length; ++i) {
            String permissionName = permissionNames[i];
            if (permissionName.equalsIgnoreCase(PERMISSION_EDIT)) {
                this.permissions[i] = Permission.EDIT;
                continue;
            }
            if (permissionName.equalsIgnoreCase(PERMISSION_VIEW)) {
                this.permissions[i] = Permission.VIEW;
                continue;
            }
            if (permissionName.equalsIgnoreCase(PERMISSION_ADMINISTER)) {
                this.permissions[i] = Permission.ADMINISTER;
                continue;
            }
            throw new WorkflowException("Invalid permission '" + permissionName + "', it can only be one of edit, view, administer");
        }
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        StringBuffer sb = new StringBuffer(this.not ? "!" : "");
        String separator = "";
        for (Permission permission : this.permissions) {
            sb.append(separator).append(permission.toString());
            separator = ",";
        }
        macro.addParameter("permission", (Object)sb.toString());
    }

    @Override
    public String toString(ValueStore valueStore) {
        StringBuffer sb = new StringBuffer("user has permission to ");
        for (int i = 0; i < this.permissions.length; ++i) {
            Permission permission = this.permissions[i];
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(permission.toString().toLowerCase());
        }
        sb.append(" the page");
        return sb.toString();
    }

    private PermissionManager getPermissionManager() {
        return PluginContainerManager.getComponent(PermissionManager.class);
    }
}

