/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.esignatures.resources;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsLiteAppRequired;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.esignatures.configuration.ESignaturesConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.model.ESignatureCredentials;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import java.lang.reflect.Method;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestOTPResource {
    private static final Logger log = LoggerFactory.getLogger(AbstractRestOTPResource.class);
    protected static final String APPLICATION_PERMISSION_ERROR = "The application has no permission over ";
    protected final PermissionManager permissionManager;
    protected final WorkflowsFeatureManager workflowsFeatureManager;
    protected final ESignaturesConfigurationManager eSignaturesConfigurationManager;
    protected final ComalaI18nBean comalaI18nBean;

    public AbstractRestOTPResource() {
        this.permissionManager = PluginContainerManager.getComponent(PermissionManager.class);
        this.workflowsFeatureManager = PluginContainerManager.getComponent(WorkflowsFeatureManager.class);
        this.eSignaturesConfigurationManager = PluginContainerManager.getComponent(ESignaturesConfigurationManager.class);
        this.comalaI18nBean = PluginContainerManager.getComponent(ComalaI18nBean.class);
    }

    public AbstractRestOTPResource(PermissionManager permissionManager, WorkflowsFeatureManager workflowsFeatureManager, ESignaturesConfigurationManager eSignaturesConfigurationManager, ComalaI18nBean comalaI18nBean) {
        this.permissionManager = permissionManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.eSignaturesConfigurationManager = eSignaturesConfigurationManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    public abstract class RestCommand {
        protected boolean hasAnnotation(Class clazz) {
            return null != this.getClass().getEnclosingClass().getAnnotation(clazz) || null != this.getClass().getEnclosingMethod().getAnnotation(clazz);
        }

        protected PermissionRequired getAnnotationIfExists(Method method) {
            PermissionRequired annotation = method.getAnnotation(PermissionRequired.class);
            if (annotation != null) {
                return annotation;
            }
            return method.getDeclaringClass().getDeclaredAnnotation(PermissionRequired.class);
        }

        protected RestCommand validate() throws ApplicationPermissionException {
            String credentials;
            boolean allowed = true;
            boolean skip = false;
            if (this.hasAnnotation(WorkflowsAppRequired.class)) {
                skip = allowed = AbstractRestOTPResource.this.workflowsFeatureManager.isWorkflowsApp();
            }
            if (!skip && this.hasAnnotation(WorkflowsLiteAppRequired.class)) {
                allowed = AbstractRestOTPResource.this.workflowsFeatureManager.isWorkflowsLiteApp();
            }
            if (!allowed) {
                throw new ApplicationPermissionException(AbstractRestOTPResource.APPLICATION_PERMISSION_ERROR + this.getClass().getEnclosingClass().getName() + ":" + this.getClass().getEnclosingMethod().getName());
            }
            PermissionRequired annotation = this.getAnnotationIfExists(this.getClass().getEnclosingMethod());
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            Object target = this.getValidationTarget();
            if (annotation != null) {
                for (String permission : annotation.value()) {
                    if (AbstractRestOTPResource.this.permissionManager.hasPermission((User)user, Permission.forName((String)permission), target)) continue;
                    throw new ApplicationPermissionException(user.getName() + " has no " + permission + " permission over " + target);
                }
            }
            if ((credentials = AbstractRestOTPResource.this.eSignaturesConfigurationManager.getESignaturesCredentials()) == null || credentials.equals(ESignatureCredentials.Credentials.CONFLUENCE.getValue())) {
                throw new ApplicationPermissionException("Signing Token Credentials are not enabled");
            }
            return this;
        }

        public Object getValidationTarget() {
            return PermissionManager.TARGET_APPLICATION;
        }

        public final Response execute() {
            try {
                return this.validate().doExecute();
            }
            catch (ApplicationPermissionException e) {
                if (e.getMessage().contains(AbstractRestOTPResource.APPLICATION_PERMISSION_ERROR)) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
            }
            catch (Exception e) {
                log.error("Exception caught during signing token setup process", (Throwable)e);
                JSONObject error = new JSONObject();
                error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                error.put("message", e.getMessage() != null ? e.getMessage() : "Internal server error");
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
            }
        }

        public abstract Response doExecute() throws Exception;
    }
}

