/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc.api;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.ipc.api.AbstractAdhocService;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.workflow.PageSectionsManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.WorkflowService;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="workflowService")
@ExportAsService
public class DefaultWorkflowService
extends AbstractAdhocService
implements WorkflowService {
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final WorkflowContainerManager workflowContainerManager;
    private final AdhocWorkflowManager adhocWorkflowManager;
    private final WorkflowTemplateManager workflowTemplateManager;
    private final PageSectionsManager pageSectionsManager;

    public DefaultWorkflowService(@ComponentImport UserAccessor userAccessor, WorkflowAccessor workflowAccessor, StateManager stateManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowContainerManager workflowContainerManager, AdhocWorkflowManager adhocWorkflowManager, @Qualifier(value="workflowTemplateManager") WorkflowTemplateManager workflowTemplateManager, PageSectionsManager pageSectionsManager) {
        super(userAccessor, workflowAccessor, stateManager);
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.workflowContainerManager = workflowContainerManager;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.workflowTemplateManager = workflowTemplateManager;
        this.pageSectionsManager = pageSectionsManager;
    }

    @Override
    public String getVersion() {
        return this.workflowConfigurationManager.getConfiguration().getVersion();
    }

    @Override
    public Workflow loadWorkflow(ContentEntityObject content, String workflowMarkup) throws WorkflowException {
        AbstractPage page = (AbstractPage)content;
        Workflow workflow = this.workflowContainerManager.renderWorkflow(workflowMarkup);
        return this.adhocWorkflowManager.savePageWorkflow(page, workflow, true);
    }

    @Override
    public Workflow loadWorkflow(Space space, String workflowMarkup) throws WorkflowException {
        Workflow workflow = this.workflowContainerManager.renderWorkflow(workflowMarkup);
        this.workflowContainerManager.saveProductionWorkflow(space.getKey(), workflow, "");
        return workflow;
    }

    @Override
    public void removeWorkflow(ContentEntityObject content) {
        AbstractPage page = (AbstractPage)content;
        this.adhocWorkflowManager.removeWorkflow(page);
    }

    @Override
    public void removeWorkflow(Space space, String workflowName) {
        this.workflowContainerManager.removeProductionWorkflow(space.getKey(), workflowName);
    }

    @Override
    public Workflow getWorkflow(ContentEntityObject content) {
        try {
            AbstractPage page = (AbstractPage)content;
            return this.adhocWorkflowManager.getPageWorkflow(page);
        }
        catch (WorkflowException workflowException) {
            return null;
        }
    }

    @Override
    public void activateSpaceWorkflow(Space space, String workflowName) {
        this.activateSpaceWorkflow(true, space.getKey(), workflowName);
    }

    @Override
    public void deactivateSpaceWorflow(Space space, String workflowName) {
        this.activateSpaceWorkflow(false, space.getKey(), workflowName);
    }

    @Override
    public Workflow getWorkflow(Space space, String workflowName) {
        try {
            return this.workflowContainerManager.getProductionWorkflow(space.getKey(), workflowName);
        }
        catch (WorkflowException workflowException) {
            return null;
        }
    }

    @Override
    public List<com.comalatech.workflow.model.Workflow> getWorkflows(Space space) {
        return this.convertWorkflowList(this.workflowContainerManager.getAllProductionWorkflows(space.getKey()));
    }

    @Override
    public List<com.comalatech.workflow.model.Workflow> getActiveWorkflows(ContentEntityObject content) {
        try {
            PageWorkflows pageWorkflows = this.workflowAccessor.getWorkflows((AbstractPage)content);
            if (pageWorkflows != null) {
                return this.convertWorkflowList(pageWorkflows.getWorkflows());
            }
        }
        catch (com.comalatech.confluence.workflow.WorkflowException workflowException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public List<com.comalatech.workflow.model.Workflow> getWorkflowTemplates() {
        return this.workflowTemplateManager.getWorkflowTemplates();
    }

    @Override
    @Deprecated
    public void addWorkflowTemplate(Space space, String workflowMarkup) throws WorkflowException {
        this.workflowTemplateManager.addWorkflowTemplate(space, workflowMarkup);
    }

    @Override
    @Deprecated
    public void removeWorkflowTemplate(Space space, String workflowName) {
        this.workflowTemplateManager.removeWorkflowTemplate(space, workflowName);
    }

    @Override
    @Deprecated
    public List<com.comalatech.workflow.model.Workflow> getWorkflowTemplates(Space space) {
        return this.workflowTemplateManager.getWorkflowTemplates(space);
    }

    protected void activateSpaceWorkflow(boolean activate, String spaceKey, String workflowName) {
        try {
            Workflow workflow = this.workflowContainerManager.getProductionWorkflow(spaceKey, workflowName);
            if (workflow != null) {
                workflow.setActive(activate);
                this.workflowContainerManager.saveProductionWorkflow(spaceKey, workflow, null);
            }
        }
        catch (com.comalatech.confluence.workflow.WorkflowException workflowException) {
            // empty catch block
        }
    }

    protected List<com.comalatech.workflow.model.Workflow> convertWorkflowList(List<Workflow> list) {
        ArrayList<com.comalatech.workflow.model.Workflow> workflowList = new ArrayList<com.comalatech.workflow.model.Workflow>();
        for (Workflow workflow : list) {
            workflowList.add(workflow);
        }
        return workflowList;
    }

    @Override
    public String getCustomThemeWorkflowHtml(ContentEntityObject content) {
        return "";
    }

    @Override
    public Map<String, String> getWorkflowHtmlElements(ContentEntityObject content) {
        return this.getWorkflowHtmlElements(content, false);
    }

    @Override
    public Map<String, String> getWorkflowHtmlElements(ContentEntityObject content, boolean publishedVersion) {
        HashMap<String, String> htmlMap = new HashMap<String, String>(5);
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows((AbstractPage)content.getLatestVersion());
        if (pageWorkflows != null) {
            PageSectionsManager.PageSections pageSections = this.pageSectionsManager.renderPageSections(pageWorkflows, null, publishedVersion);
            htmlMap.put("header", pageSections.getHeader());
            htmlMap.put("footer", pageSections.getFooter());
        } else {
            htmlMap.put("header", "");
            htmlMap.put("footer", "");
        }
        htmlMap.put("menu", "");
        return htmlMap;
    }
}

