/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.ipc.WorkflowReporterMacroDelegate;
import com.comalatech.confluence.util.OsgiUtils;
import com.comalatech.confluence.workflowreports.WorkflowReportManager;
import com.comalatech.workflow.ContentReportingService;
import java.lang.reflect.Field;
import java.util.Map;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.randombits.confluence.support.MacroInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowReporterMacro
extends BaseMacro
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(WorkflowReporterMacro.class);
    public static final String ABSTRACT_REPORTER_MACRO_CLASS = "net.customware.reporting.confluence.macro.AbstractReporterMacro";
    public static final String REPORTING_MACRO_ASSISTANT_CLASS = "net.customware.reporting.confluence.ReportingMacroAssistant";
    public static final String LICENSE_CHECKER_CLASS = "net.customware.reporting.confluence.license.LicenseChecker";
    protected final ContentReportingService contentReportingService;
    private final WorkflowReportManager workflowReportManager;
    private final ComalaI18nBean comalaI18nBean;

    public WorkflowReporterMacro(ContentReportingService contentReportingService, WorkflowReportManager workflowReportManager, ComalaI18nBean comalaI18nBean) {
        this.contentReportingService = contentReportingService;
        this.workflowReportManager = workflowReportManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) {
        Class<?> licenseCheckerClass;
        Class<?> reportingMacroAssistantClass;
        Class<?> abstractReporterMacroClass;
        ClassLoader cl;
        try {
            cl = ((Object)((Object)this)).getClass().getClassLoader();
            abstractReporterMacroClass = cl.loadClass(ABSTRACT_REPORTER_MACRO_CLASS);
            reportingMacroAssistantClass = cl.loadClass(REPORTING_MACRO_ASSISTANT_CLASS);
            licenseCheckerClass = cl.loadClass(LICENSE_CHECKER_CLASS);
        }
        catch (ClassNotFoundException cnf) {
            return this.comalaI18nBean.getText("com.comalatech.macro.reporting.error.reporting-plugin-not-found");
        }
        Object reportingMacroAssistant = OsgiUtils.getService(reportingMacroAssistantClass);
        Object licenseChecker = OsgiUtils.getService(licenseCheckerClass);
        if (reportingMacroAssistant == null || licenseChecker == null) {
            return this.comalaI18nBean.getText("com.comalatech.macro.reporting.error.nullServices");
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(cl);
        enhancer.setSuperclass(abstractReporterMacroClass);
        MethodInterceptor methodInterceptor = (obj, method, args, proxy) -> {
            if (method.getDeclaringClass() != Object.class && "createQuery".equals(method.getName())) {
                com.servicerocket.confluence.randombits.support.confluence.MacroInfo macroInfo = (com.servicerocket.confluence.randombits.support.confluence.MacroInfo)args[0];
                MacroInfo macroInfo1 = new MacroInfo(macroInfo.getMacroParamsMap(), macroInfo.getMacroBody(), conversionContext.getPageContext());
                return new WorkflowReporterMacroDelegate(this.workflowReportManager).createQuery(macroInfo1);
            }
            return proxy.invokeSuper(obj, args);
        };
        try {
            enhancer.setCallback(methodInterceptor);
            Macro macro = (Macro)enhancer.create(new Class[]{reportingMacroAssistantClass, licenseCheckerClass}, new Object[]{reportingMacroAssistant, licenseChecker});
            Field field = macro.getClass().getSuperclass().getDeclaredField("valueType");
            field.setAccessible(true);
            field.set(macro, AbstractPage.class);
            return macro.execute(params, body, conversionContext);
        }
        catch (Exception ex) {
            String i18nError = this.comalaI18nBean.getText("com.comalatech.macro.reporting.error.general-error");
            log.error(i18nError, (Throwable)ex);
            return i18nError;
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map map, String body, RenderContext rc) throws MacroException {
        return this.execute((Map<String, String>)map, body, (ConversionContext)new DefaultConversionContext(rc));
    }
}

