/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.entity.domain.metadata.Metadata;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageMetadataMigrationData;
import com.comalatech.confluence.cloud.migration.usecases.repository.MetadataRepository;
import com.comalatech.confluence.cloud.migration.usecases.repository.entity.MetadataRecord;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GeneratePageMetadataUseCase
implements GeneratePageMetadataMigrationData {
    private static final Logger log = LoggerFactory.getLogger(GeneratePageMetadataUseCase.class);
    private final SpaceManager spaceManager;
    private final MetadataRepository metadataRepository;
    private final ReadWriteTransactionService readWriteTransactionService;

    public GeneratePageMetadataUseCase(@ComponentImport SpaceManager spaceManager, MetadataRepository metadataRepository, ReadWriteTransactionService readWriteTransactionService) {
        this.spaceManager = spaceManager;
        this.metadataRepository = metadataRepository;
        this.readWriteTransactionService = readWriteTransactionService;
    }

    @Override
    public List<Metadata> generatePageMetadata(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            log.warn("No space found to retrieve the content metadata for the space key {}", (Object)spaceKey);
            return null;
        }
        return this.readWriteTransactionService.executeInReadOnlyTransaction(() -> {
            List<MetadataRecord> records = this.metadataRepository.findAllMetadataBySpace(space);
            ArrayList metadata = new ArrayList();
            records.forEach(record -> metadata.add(new Metadata(record.getContentId(), record.getKey(), record.getValue(), null)));
            return metadata;
        });
    }
}

