/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.approvals.rest.resources;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.approvals.utils.ApprovalUtils;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import com.comalatech.confluence.workflow.restv2.resources.AbstractRestResource;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/page")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@PermissionRequired(value={"EDIT"})
public class ApprovalPageResource
extends AbstractRestResource {
    private static final Logger log = LoggerFactory.getLogger(ApprovalPageResource.class);
    private final AdhocWorkflowManager adhocWorkflowManager;

    @Inject
    public ApprovalPageResource() {
        this.adhocWorkflowManager = PluginContainerManager.getComponent(AdhocWorkflowManager.class);
    }

    @Autowired
    public ApprovalPageResource(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport PageManager pageManager, AdhocWorkflowManager adhocWorkflowManager, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager, ComalaI18nBean comalaI18nBean) {
        super(permissionManager, spaceManager, pageManager, workflowMarkupManager, workflowsFeatureManager, comalaI18nBean);
        this.adhocWorkflowManager = adhocWorkflowManager;
    }

    @POST
    @Path(value="/{contentId}/approval")
    public Response createPageApproval(@PathParam(value="contentId") Long contentId) {
        return this.savePageApproval(contentId, true);
    }

    private Response savePageApproval(final Long contentId, final boolean setInitialialState) {
        return new AbstractRestResource.RestPageCommand(contentId){

            @Override
            public Response doExecute() {
                AbstractPage page = ApprovalPageResource.this.pageManager.getAbstractPage(contentId.longValue());
                if (page == null) {
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                Workflow workflow = null;
                try {
                    workflow = ApprovalPageResource.this.adhocWorkflowManager.parseWorkflowMarkup(ApprovalUtils.SIMPLE_APPROVAL_WORKFLOW);
                    if (StringUtils.isNotBlank((CharSequence)workflow.getErrorMessage())) {
                        log.error("comalatech.awp.designer.error.markup" + workflow.getErrorMessage());
                        return Response.serverError().build();
                    }
                    Workflow updatedWorkflow = ApprovalPageResource.this.adhocWorkflowManager.savePageWorkflow(page, workflow, setInitialialState);
                    return Response.ok((Object)Mappers.workflowMapper.toRest(updatedWorkflow)).build();
                }
                catch (WorkflowException ex) {
                    log.error("Error creating/updating page approval", (Throwable)ex);
                    return Response.serverError().build();
                }
                catch (MapperException mEx) {
                    log.error("Mapper error trying to restify a approval", (Throwable)mEx);
                    return Response.serverError().build();
                }
            }
        }.execute();
    }
}

