/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoctasks.rest.model;

import com.comalatech.confluence.adhocworkflows.rest.model.User;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="task")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Task {
    public static final int MAX_TASK_NAME = 40;
    private String id;
    private String name;
    private String shortName;
    private User assignee;
    private boolean completed;
    private List<Action> actions = new ArrayList<Action>();
    private String hint;
    private String date;
    private String lastAction;
    private User actor;
    private String comment;
    private String dueDate;
    private String friendlyDueDate;

    public Task() {
    }

    public Task(String id, String name, User assignee, boolean completed) {
        this();
        this.id = id;
        this.name = name;
        this.shortName = name.length() > 40 ? name.substring(0, 40) + "..." : name;
        this.assignee = assignee;
        this.completed = completed;
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public User getAssignee() {
        return this.assignee;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setComment(String comment) {
        if (comment == null) {
            comment = "";
        }
        this.comment = comment;
    }

    public User getActor() {
        return this.actor;
    }

    public void setActor(User actor) {
        this.actor = actor;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getLastAction() {
        return this.lastAction;
    }

    public void setLastAction(String lastAction) {
        this.lastAction = lastAction;
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public String getFriendlyDueDate() {
        return this.friendlyDueDate;
    }

    public void setFriendlyDueDate(String friendlyDueDate) {
        this.friendlyDueDate = friendlyDueDate;
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class Action {
        public static final Action VIEW = new Action("view", "com.comalatech.tasks.actions.complete");
        public static final Action COMPLETE = new Action("complete", "com.comalatech.tasks.actions.complete");
        public static final Action ASSIGN = new Action("assign", "com.comalatech.tasks.actions.assign");
        public static final Action REMOVE = new Action("remove", "com.comalatech.tasks.actions.delete");
        String id;
        String caption;

        public Action() {
        }

        Action(String id, String caption) {
            this.id = id;
            this.caption = caption;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getCaption() {
            return ComalaI18nBean.getComalaI18nBean().getText(this.caption);
        }

        public void setCaption(String caption) {
            this.caption = caption;
        }
    }
}

