/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

/**
 * @since 4.0
 */
var CML = CML || {
    VERSION: '0.2',
    
    allVersions: function () {
        if(console.group) {
            console.group('Confluence versions');
        }
        
        console.log('Confluence:', AJS.params.versionNumber);
        console.log('AJS:', AJS.version);
        console.log('jQuery:', jQuery.fn.jquery);
        console.log('jQuery UI:', jQuery.ui.version);

        console.log('Backbone:', Backbone.VERSION);
        console.log('Underscore:', _.VERSION);
        
        if(console.group) {
            console.groupEnd();
            console.group('Comalatech versions');
        }

        console.log('CML:', this.VERSION);
        console.log('AWP:', AWP.VERSION);

        if(console.group) {
            console.groupEnd();
        }
    },

    /*
     * Equivalent to Adhoc.getUrlParams()
     */
    getUrlParameters: function() {
        var map = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m,key,value) {
            map[key] = value;
        });
        return map;
    }
};

/*
 * indexOf is a recent addition to the ECMA-262 standard
 * source: https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Global_Objects/Array/IndexOf
 */
if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function (searchElement /*, fromIndex */ ) {
        "use strict";
        if (this == null) {
            throw new TypeError();
        }
        var t = Object(this);
        var len = t.length >>> 0;
        if (len === 0) {
            return -1;
        }
        var n = 0;
        if (arguments.length > 1) {
            n = Number(arguments[1]);
            if (n != n) { // shortcut for verifying if it's NaN
                n = 0;
            } else if (n != 0 && n != Infinity && n != -Infinity) {
                n = (n > 0 || -1) * Math.floor(Math.abs(n));
            }
        }
        if (n >= len) {
            return -1;
        }
        var k = n >= 0 ? n : Math.max(len - Math.abs(n), 0);
        for (; k < len; k++) {
            if (k in t && t[k] === searchElement) {
                return k;
            }
        }
        return -1;
    }
}