/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.user;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.Collections;
import org.randombits.confluence.filtering.criteria.AutowiredCriterion;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;
import org.randombits.confluence.filtering.criteria.SourceCriterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupMemberCriterion
extends AutowiredCriterion
implements SourceCriterion<String> {
    private String groupname;
    private UserAccessor userAccessor;

    public GroupMemberCriterion(String groupname) {
        this.groupname = groupname;
    }

    public GroupMemberCriterion(Group group) {
        this.groupname = group.getName();
    }

    @Override
    public boolean matches(Object object) {
        String username = null;
        if (object instanceof User) {
            username = ((User)object).getName();
        } else if (object instanceof String) {
            username = (String)object;
        }
        if (username != null) {
            return this.userAccessor.hasMembership(this.groupname, username);
        }
        return false;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public Collection<String> getMatchingValues() {
        Group group = this.userAccessor.getGroup(this.groupname);
        if (group == null) {
            return Collections.EMPTY_LIST;
        }
        return this.userAccessor.getMemberNamesAsList(group);
    }

    public String toString() {
        return "{group member: " + this.groupname + "}";
    }

    @Override
    public SourceCriterion.Weight getWeight() {
        return SourceCriterion.Weight.MEDIUM;
    }

    public static class Interpretor
    implements CriterionInterpreter {
        public Criterion createCriterion(String value) {
            return new GroupMemberCriterion(value);
        }
    }
}

