/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.model;

import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public enum ApprovalsReportParameters {
    SPACE("space", "@self"),
    MAX_ITEMS_PER_PAGE("maxItems", "20"),
    COLUMNS_TO_SHOW("columns", "title,approval,state,approvers,pending approvers,last page update,status"),
    ASSIGNEE("assignee"),
    PARENT_PAGE("parent"),
    ANCESTOR_PAGE("ancestor"),
    LABEL("label"),
    APPROVAL_NAME("approvalName"),
    APPROVAL_STATUS("approvalStatus", "Any"),
    STATE("state"),
    WORKFLOW("workflow"),
    CQL_FILTER("cqlFilter");

    final String key;
    String defaultValue;

    private ApprovalsReportParameters(String key) {
        this.key = key;
    }

    private ApprovalsReportParameters(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public static Optional<ApprovalsReportParameters> fromString(String text) {
        return Arrays.stream(ApprovalsReportParameters.values()).filter(reportFilter -> reportFilter.key.equalsIgnoreCase(text)).findFirst();
    }

    public static List<ReportParameter> getFiltersFrom(Set<Map.Entry<?, ?>> macroParameterSet) {
        ArrayList<ReportParameter> approvalsReportFilters = new ArrayList<ReportParameter>();
        for (Map.Entry<?, ?> macroParam : macroParameterSet) {
            ApprovalsReportParameters filter = ApprovalsReportParameters.fromString(macroParam.getKey().toString()).orElse(null);
            if (Objects.isNull((Object)filter)) continue;
            String value = macroParam.getValue() == null ? null : macroParam.getValue().toString().trim();
            approvalsReportFilters.add(new ReportParameter(filter.key, new StringReportParameterValue(value, filter.defaultValue)));
        }
        ApprovalsReportParameters.addMandatoryParameters(approvalsReportFilters);
        return approvalsReportFilters;
    }

    private static void addMandatoryParameters(List<ReportParameter> approvalsReportFilters) {
        ApprovalsReportParameters.fillReportFilter(approvalsReportFilters, SPACE.getKey(), SPACE.getDefaultValue());
        ApprovalsReportParameters.fillReportFilter(approvalsReportFilters, MAX_ITEMS_PER_PAGE.getKey(), MAX_ITEMS_PER_PAGE.getDefaultValue());
        ApprovalsReportParameters.fillReportFilter(approvalsReportFilters, APPROVAL_STATUS.getKey(), APPROVAL_STATUS.getDefaultValue());
        ApprovalsReportParameters.fillReportFilter(approvalsReportFilters, COLUMNS_TO_SHOW.getKey(), COLUMNS_TO_SHOW.getDefaultValue());
        ApprovalsReportParameters.fillReportFilter(approvalsReportFilters, ASSIGNEE.getKey(), ASSIGNEE.getDefaultValue());
    }

    private static void fillReportFilter(List<ReportParameter> reportParameterList, String key, String defaultValue) {
        boolean existParameter = reportParameterList.stream().anyMatch(param -> param.getKey().equals(key));
        if (!existParameter) {
            reportParameterList.add(new ReportParameter(key, new StringReportParameterValue(null, defaultValue)));
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

