/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.parser;

import com.comalatech.confluence.workflow.macros.parser.MacroElement;
import com.comalatech.confluence.workflow.macros.parser.MacroText;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Macro
implements MacroElement {
    public static final char TOKEN_MACRO_START = '{';
    public static final char TOKEN_MACRO_END = '}';
    public static final char TOKEN_ATTRIBUTE_START = ':';
    public static final char TOKEN_ATTRIBUTE_SEPARATOR = '|';
    public static final char TOKEN_ATTRIBUTE_EQUALS = '=';
    public static final String ATTRIBUTE_DEFAULT = "name";
    public String name;
    public Map<String, String> attributes;
    @com.fasterxml.jackson.annotation.JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @com.fasterxml.jackson.annotation.JsonSubTypes(value={@JsonSubTypes.Type(value=Macro.class, name="macro"), @JsonSubTypes.Type(value=MacroText.class, name="macro-text")})
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Macro.class, name="macro"), @JsonSubTypes.Type(value=MacroText.class, name="macro-text")})
    public List<MacroElement> body;

    @Override
    public String toMacro() {
        StringBuilder builder = new StringBuilder();
        builder.append('{').append(this.name);
        if (this.attributes != null && !this.attributes.isEmpty()) {
            builder.append(':');
            List attrs = this.attributes.keySet().stream().filter(key -> !key.equals(ATTRIBUTE_DEFAULT)).map(key -> key + "=" + this.attributes.get(key)).collect(Collectors.toList());
            if (this.attributes.containsKey(ATTRIBUTE_DEFAULT)) {
                attrs.add(0, this.attributes.get(ATTRIBUTE_DEFAULT));
            }
            builder.append(StringUtils.join(attrs, (char)'|'));
        }
        builder.append('}');
        if (this.body != null) {
            this.body.stream().forEach(elem -> builder.append(elem.toMacro()));
            builder.append('{').append(this.name).append('}');
        }
        return builder.toString();
    }

    @Override
    public String toString(int indent) {
        StringBuilder builder = new StringBuilder();
        builder.append("MACRO>").append(this.name);
        if (this.attributes != null) {
            List attrs = this.attributes.keySet().stream().map(key -> key + "=" + this.attributes.get(key)).collect(Collectors.toList());
            builder.append("(").append(StringUtils.join(attrs, (String)",")).append(")");
        }
        if (this.body != null) {
            builder.append(this.body.stream().map(elem -> elem.toString(indent + 2)).collect(Collectors.toList()));
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString(0);
    }
}

