/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.comalatech.confluence.util.MapDifferenceResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MiscUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String[] splitAndTrim(String str) {
        if (!StringUtils.isNotBlank((CharSequence)str)) {
            return EMPTY_STRING_ARRAY;
        }
        String[] values = str.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public static String listToString(String[] list) {
        if (list != null && list.length != 0) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (String s : list) {
                sb.append(separator).append(s);
                separator = ",";
            }
            return sb.toString();
        }
        return "";
    }

    public static String listToCommaSeparatedList(List list, Extractor extractor) {
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (Object o : list) {
            sb.append(separator).append(extractor.getKey(o));
            separator = ",";
        }
        return sb.toString();
    }

    public static String stringListToCommaSeparatedList(String[] names, String lastSeparator) {
        if (names == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                if (i < names.length - 1) {
                    sb.append(", ");
                } else {
                    sb.append(lastSeparator);
                }
            }
            sb.append(names[i]);
        }
        return sb.toString();
    }

    public static <T> List<List<T>> partition(List<T> list, int batchSize) {
        ArrayList<List<T>> partitions = new ArrayList<List<T>>();
        for (int i = 0; i < list.size(); i += batchSize) {
            partitions.add(list.subList(i, Math.min(i + batchSize, list.size())));
        }
        return partitions;
    }

    public static <K, V> MapDifferenceResult<K, V> compareMaps(Map<K, V> leftMap, Map<K, V> rightMap) {
        K key;
        HashMap<K, V> onlyInOld = new HashMap<K, V>();
        HashMap<K, V> onlyInNew = new HashMap<K, V>();
        HashMap<K, Pair> differing = new HashMap<K, Pair>();
        HashMap<K, V> common = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : leftMap.entrySet()) {
            key = entry.getKey();
            V leftValue = entry.getValue();
            if (rightMap.containsKey(key)) {
                V rightValue = rightMap.get(key);
                if (Objects.equals(leftValue, rightValue)) {
                    common.put(key, leftValue);
                    continue;
                }
                differing.put(key, Pair.of(leftValue, rightValue));
                continue;
            }
            onlyInOld.put(key, leftValue);
        }
        for (Map.Entry<K, V> entry : rightMap.entrySet()) {
            key = entry.getKey();
            if (leftMap.containsKey(key)) continue;
            onlyInNew.put(key, entry.getValue());
        }
        return new MapDifferenceResult(onlyInOld, onlyInNew, differing, common);
    }

    public static interface Extractor {
        public String getKey(Object var1);
    }
}

