/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.users;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.comalatech.confluence.adhocworkflows.rest.model.User;
import com.comalatech.confluence.adhocworkflows.rest.model.UserSearchResult;
import com.comalatech.confluence.adhocworkflows.rest.model.UsersQuerySearchResults;
import com.comalatech.confluence.contributors.ContributorsManager;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.comalatech.confluence.workflow.rest.model.Link;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class UserSearchManager {
    private static final Logger log = LoggerFactory.getLogger(UserSearchManager.class);
    private final GlobalSettingsManager globalSettingsManager;
    private final UserAccessor userAccessor;
    private final GroupManager groupManager;
    private final BootstrapManager bootstrapManager;
    private final ContributorsManager contributorsManager;
    private final WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;

    public UserSearchManager(@ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, @ComponentImport UserAccessor userAccessor, @ComponentImport GroupManager groupManager, @ComponentImport BootstrapManager bootstrapManager, ContributorsManager contributorsManager, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager) {
        this.globalSettingsManager = globalSettingsManager;
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
        this.bootstrapManager = bootstrapManager;
        this.contributorsManager = contributorsManager;
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
    }

    public UsersQuerySearchResults getContributors(AbstractPage page, boolean hasContributors) {
        return this.buildStaticResults(hasContributors ? this.contributorsManager.getContributors(page) : null, null, null);
    }

    public UsersQuerySearchResults buildStaticResults(String users, String groups, String excludedUsers) {
        if (log.isDebugEnabled()) {
            log.debug("building static results for userNames: " + users + "   groupNames: " + groups);
        }
        int maxAllowedApproversToShow = this.workflowAdvancedConfigurationManager.getMaxAllowedApproversToShow();
        Set<String> userList = this.parseList(users);
        Set<String> groupList = this.parseList(groups);
        Set<String> excludedUsersList = this.parseList(excludedUsers);
        HashSet<String> userNameSet = new HashSet<String>();
        for (String string : userList) {
            if (userNameSet.size() >= maxAllowedApproversToShow || excludedUsersList.contains(string) || this.userAccessor.isDeactivated(string)) continue;
            userNameSet.add(string);
        }
        if (userNameSet.size() < maxAllowedApproversToShow) {
            for (String string : groupList) {
                try {
                    Group group = this.groupManager.getGroup(string);
                    if (group == null) continue;
                    for (String username : this.groupManager.getMemberNames(group)) {
                        if (!excludedUsersList.contains(username) && !this.userAccessor.isDeactivated(username)) {
                            userNameSet.add(username);
                        }
                        if (userNameSet.size() < maxAllowedApproversToShow) continue;
                    }
                }
                catch (EntityException e) {
                    log.error("Workflow Error getting group members for group: " + string, (Throwable)e);
                }
            }
        }
        ArrayList<ConfluenceUser> userNames = new ArrayList<ConfluenceUser>();
        for (String userName : userNameSet) {
            ConfluenceUser user = this.userAccessor.getUserByName(userName);
            if (user == null) continue;
            userNames.add(user);
        }
        UsersQuerySearchResults usersQuerySearchResults = this.buildSearchResults(userNames);
        usersQuerySearchResults.totalSize = -1;
        return usersQuerySearchResults;
    }

    protected UsersQuerySearchResults buildSearchResults(List<ConfluenceUser> users) {
        UsersQuerySearchResults results = new UsersQuerySearchResults();
        ArrayList<UserSearchResult> userResults = new ArrayList<UserSearchResult>();
        for (ConfluenceUser user : users) {
            UserSearchResult userResult = new UserSearchResult();
            userResult.id = user.getName();
            userResult.username = user.getName();
            userResult.title = user.getFullName();
            ProfilePictureInfo info = this.userAccessor.getUserProfilePicture((com.atlassian.user.User)user);
            String base = this.bootstrapManager.getWebAppContextPath();
            try {
                userResult.thumbnailLink = new Link(new URI(this.globalSettingsManager.getGlobalSettings().getBaseUrl() + info.getUriReference().substring(base.length())));
            }
            catch (URISyntaxException e) {
                log.error("Can not create thumbnail link for user " + user.getName() + ".", (Throwable)e);
            }
            userResults.add(userResult);
        }
        results.results = userResults;
        results.totalSize = users.size();
        return results;
    }

    protected Set<String> parseList(String commaSeparatedList) {
        LinkedHashSet<String> values;
        if (commaSeparatedList != null) {
            String[] list = StringUtils.split((String)commaSeparatedList, (String)",");
            values = new LinkedHashSet(list.length);
            for (int i = 0; i < list.length; ++i) {
                values.add(list[i].trim());
            }
        } else {
            values = new LinkedHashSet<String>(0);
        }
        return values;
    }

    public User makeUser(String name) {
        return this.makeUser(name, null);
    }

    public User makeUser(String name, String roleName) {
        ConfluenceUser user = this.userAccessor.getUserByName(name);
        if (user == null) {
            return null;
        }
        return this.makeUser(user, roleName);
    }

    public User makeUser(ConfluenceUser user, String roleName) {
        ProfilePictureInfo picture = this.userAccessor.getUserProfilePicture((com.atlassian.user.User)user);
        String picUrl = null;
        if (picture != null) {
            picUrl = picture.getUriReference();
        }
        return new User(user.getName(), roleName, user.getFullName(), picUrl);
    }
}

