/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.dataextractor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerDateAndTimeDeserialize
extends JsonDeserializer<Date> {
    private static final Logger log = LoggerFactory.getLogger(CustomerDateAndTimeDeserialize.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public Date deserialize(JsonParser paramJsonParser, DeserializationContext paramDeserializationContext) throws IOException {
        String str = paramJsonParser.getText().trim();
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            log.warn("Error parsing date:" + str + ". Retrying with param deserialization context parser.");
            return paramDeserializationContext.parseDate(str);
        }
    }
}

