/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc.api;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.ipc.api.AbstractAdhocService;
import com.comalatech.confluence.ipc.api.contracts.CredentialManager;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.workflow.ApprovalService;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.model.Approval;
import com.comalatech.workflow.model.Assignee;
import com.comalatech.workflow.model.Rejection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class DefaultApprovalService
extends AbstractAdhocService
implements ApprovalService {
    private static final Logger log = LoggerFactory.getLogger(DefaultApprovalService.class);
    private final ApprovalManager approvalManager;
    private final CredentialManager credentialManager;

    public DefaultApprovalService(@ComponentImport UserAccessor userAccessor, WorkflowAccessor workflowAccessor, StateManager stateManager, ApprovalManager approvalManager, CredentialManager credentialManager) {
        super(userAccessor, workflowAccessor, stateManager);
        this.approvalManager = approvalManager;
        this.credentialManager = credentialManager;
    }

    @Override
    public Approval approve(ContentEntityObject content, final String name, final String userName, final String password, final String comment) throws WorkflowException {
        return (Approval)new AbstractAdhocService.WorkflowCommand(content){

            @Override
            public Object doCommand(AbstractPage page, ConfluenceUser user, PageWorkflows pageWorkflows, PageState state) throws WorkflowException {
                ApprovalCheck check = DefaultApprovalService.this.approvalManager.approvePage(page, name, true, comment, user, false, DefaultApprovalService.this.credentialManager.checkUserCredential(userName), DefaultApprovalService.this.credentialManager.checkPasswordCredential(password), false);
                return check.getLastApproval();
            }
        }.execute();
    }

    @Override
    public Rejection reject(ContentEntityObject content, final String name, final String userName, final String password, final String comment) throws WorkflowException {
        return (Rejection)new AbstractAdhocService.WorkflowCommand(content){

            @Override
            public Object doCommand(AbstractPage page, ConfluenceUser user, PageWorkflows pageWorkflows, PageState state) throws WorkflowException {
                ApprovalCheck check = DefaultApprovalService.this.approvalManager.approvePage(page, name, false, comment, user, false, DefaultApprovalService.this.credentialManager.checkUserCredential(userName), DefaultApprovalService.this.credentialManager.checkPasswordCredential(password), false);
                return check.getLastRejection();
            }
        }.execute();
    }

    @Override
    public void assign(ContentEntityObject content, final String approvalName, final Assignee assignee, final String comment) throws WorkflowException {
        new AbstractAdhocService.WorkflowCommand(content){

            @Override
            public Object doCommand(AbstractPage page, ConfluenceUser user, PageWorkflows pageWorkflows, PageState state) throws WorkflowException {
                ConfluenceUser assignedUser;
                if (log.isDebugEnabled()) {
                    log.debug("assigning user: " + assignee + " to approval: " + approvalName + " on page: " + page);
                }
                if ((assignedUser = DefaultApprovalService.this.userAccessor.getUserByName(assignee.username)) == null) {
                    throw new WorkflowException("Invalid user name " + assignee);
                }
                return DefaultApprovalService.this.approvalManager.assignApproval(page, pageWorkflows, approvalName, assignedUser, assignee.rolename, comment);
            }
        }.execute();
    }

    @Override
    public void unassign(ContentEntityObject content, final String approvalName, final String assignee, final String comment) throws WorkflowException {
        new AbstractAdhocService.WorkflowCommand(content){

            @Override
            public Object doCommand(AbstractPage page, ConfluenceUser user, PageWorkflows pageWorkflows, PageState state) throws WorkflowException {
                ConfluenceUser assignedUser;
                if (log.isDebugEnabled()) {
                    log.debug("unassigning user: " + assignee + " from approval: " + approvalName + " on page: " + page);
                }
                if ((assignedUser = DefaultApprovalService.this.userAccessor.getUserByName(assignee)) == null) {
                    assignedUser = new ConfluenceUserImpl(assignee, assignee, "");
                }
                return DefaultApprovalService.this.approvalManager.unassignApproval(page, pageWorkflows, approvalName, assignedUser, comment);
            }
        }.execute();
    }
}

