/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.accessor;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.accessor.CloudMigrationAccessor;
import com.comalatech.confluence.cloud.migration.entity.ExportMetadataRecord;
import com.comalatech.confluence.cloud.migration.entity.MigrationTaskRecord;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExportMetadataAccessor
implements CloudMigrationAccessor {
    private static final Logger log = LoggerFactory.getLogger(ExportMetadataAccessor.class);
    private final ObjectMapper objectMapper;
    private final SpaceManager spaceManager;
    private final ComalaPropertiesSetManager comalaPropertiesSetManager;
    private static final String METADATA_EXPORT_TASK_KEY = "com.comalatech.metadata.export.task";

    public ExportMetadataAccessor(@ComponentImport SpaceManager spaceManager, ComalaPropertiesSetManager comalaPropertiesSetManager) {
        this.spaceManager = spaceManager;
        this.comalaPropertiesSetManager = comalaPropertiesSetManager;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public MigrationTaskRecord getMigrationTaskStatus(String spaceKey, boolean isPerSpace) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            log.warn("There is no space for space key: " + spaceKey);
            return null;
        }
        if (space.getDescription() == null) {
            log.warn("There is no space description object for space: " + space.getKey());
        } else {
            String preCheckStr = this.comalaPropertiesSetManager.getTextProperty((ContentEntityObject)space.getDescription(), METADATA_EXPORT_TASK_KEY);
            if (preCheckStr != null) {
                return this.parseExportMetadataTaskRecord(preCheckStr);
            }
        }
        return null;
    }

    @Override
    public void setMigrationTaskStatus(String spaceKey, MigrationTaskRecord migrationTaskRecord, boolean isPerSpace) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space != null) {
            try {
                this.comalaPropertiesSetManager.setTextProperty((ContentEntityObject)space.getDescription(), METADATA_EXPORT_TASK_KEY, this.objectMapper.writeValueAsString(migrationTaskRecord));
            }
            catch (IOException e) {
                log.error("Error saving export metadata task record for space {}", (Object)space.getKey());
            }
        }
    }

    private MigrationTaskRecord parseExportMetadataTaskRecord(String exportMetadataRecord) {
        try {
            return this.objectMapper.readValue(exportMetadataRecord, ExportMetadataRecord.class);
        }
        catch (IOException e) {
            log.error("Error parsing export metadata task record:" + exportMetadataRecord);
            return null;
        }
    }
}

