/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.param.format;

import com.atlassian.confluence.util.GeneralUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Separator {
    private static final Pattern SEPARATOR_QUOTED = Pattern.compile("[\"']?([^\"']*)[\"']?");
    private String pre;
    private String mid;
    private String post;

    public Separator(Type type) {
        this.pre = type.prefix;
        this.mid = type.midfix;
        this.post = type.postfix;
    }

    public Separator(String pre, String mid, String post) {
        this.pre = pre;
        this.mid = mid;
        this.post = post;
    }

    public String getPre() {
        return this.pre;
    }

    public String getMid() {
        return this.mid;
    }

    public String getPost() {
        return this.post;
    }

    public static Separator parse(String separator) {
        if (separator != null) {
            Type type = Type.forName(separator);
            if (type != null) {
                return new Separator(type);
            }
            Matcher matcher = SEPARATOR_QUOTED.matcher(separator);
            if (matcher.matches()) {
                String midfix = GeneralUtil.htmlEncode((String)matcher.group(1));
                return new Separator("", midfix, "");
            }
            throw new IllegalArgumentException("Unsupported separator value: " + separator);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        BRACKETS("bracket", "[ ", " ] [ ", " ]"),
        BRACES("brace", "{ ", " } { ", " }"),
        PARENTHESES("paren", "( ", " ) ( ", " )"),
        PIPES("pipe", " | "),
        COMMAS("comma", ", "),
        NEW_LINES("newline", "<br>\n");

        private String name;
        private String prefix;
        private String midfix;
        private String postfix;

        private Type(String name, String midfix) {
            this(name, "", midfix, "");
        }

        private Type(String name, String prefix, String midfix, String postfix) {
            this.name = name;
            this.prefix = prefix;
            this.midfix = midfix;
            this.postfix = postfix;
        }

        public boolean matches(String name) {
            return name != null && name.toLowerCase().startsWith(this.name);
        }

        public static Type forName(String name) {
            for (Type type : Type.values()) {
                if (!type.matches(name)) continue;
                return type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

