/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.workflow.model.document.activity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="Object to contain a selection of type / subtypes to be filtered in a document activity query")
public class DocumentActivityActionTypesFilter {
    @ApiModelProperty(value="The type of action. Can be one of the following: approval, state, readack or task.", example="task")
    private String type;
    @ApiModelProperty(value="Comma-separated list of subtypes of the action. If no subtype is provided, then all the events of the given type will be retrieved. Can be one of the following: for \"state\" type events: override, init,\n transition, expired, expiryUpdate or expiryRemoved. For \"readack\" type events: readackCompleted. For \"approval\" type events: approvalUnassigned, approvalAssigned,\n approvalRejected or approvalApproved. For \"task\" type events: taskUnassignment, taskAssignment, taskCreation, taskUpdate, taskDeletion,\n taskCompletion, taskDueDate, taskDueDateRemoved or taskDueDateExpired.", example="[\"taskDueDateExpired\"]")
    private List<String> subtypes;

    public DocumentActivityActionTypesFilter() {
    }

    public String getType() {
        return this.type;
    }

    public List<String> getSubtypes() {
        return this.subtypes;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSubtypes(List<String> subtypes) {
        this.subtypes = subtypes;
    }

    protected DocumentActivityActionTypesFilter(DocumentActivityActionTypesFilterBuilder<?, ?> b) {
        this.type = ((DocumentActivityActionTypesFilterBuilder)b).type;
        this.subtypes = ((DocumentActivityActionTypesFilterBuilder)b).subtypes;
    }

    public static DocumentActivityActionTypesFilterBuilder<?, ?> builder() {
        return new DocumentActivityActionTypesFilterBuilderImpl();
    }

    public DocumentActivityActionTypesFilterBuilder<?, ?> toBuilder() {
        return new DocumentActivityActionTypesFilterBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentActivityActionTypesFilter)) {
            return false;
        }
        DocumentActivityActionTypesFilter other = (DocumentActivityActionTypesFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<String> this$subtypes = this.getSubtypes();
        List<String> other$subtypes = other.getSubtypes();
        return !(this$subtypes == null ? other$subtypes != null : !((Object)this$subtypes).equals(other$subtypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentActivityActionTypesFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<String> $subtypes = this.getSubtypes();
        result = result * 59 + ($subtypes == null ? 43 : ((Object)$subtypes).hashCode());
        return result;
    }

    public String toString() {
        return "DocumentActivityActionTypesFilter(type=" + this.getType() + ", subtypes=" + this.getSubtypes() + ")";
    }

    private static final class DocumentActivityActionTypesFilterBuilderImpl
    extends DocumentActivityActionTypesFilterBuilder<DocumentActivityActionTypesFilter, DocumentActivityActionTypesFilterBuilderImpl> {
        private DocumentActivityActionTypesFilterBuilderImpl() {
        }

        @Override
        protected DocumentActivityActionTypesFilterBuilderImpl self() {
            return this;
        }

        @Override
        public DocumentActivityActionTypesFilter build() {
            return new DocumentActivityActionTypesFilter(this);
        }
    }

    public static abstract class DocumentActivityActionTypesFilterBuilder<C extends DocumentActivityActionTypesFilter, B extends DocumentActivityActionTypesFilterBuilder<C, B>> {
        private String type;
        private List<String> subtypes;

        protected B $fillValuesFrom(C instance) {
            DocumentActivityActionTypesFilterBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DocumentActivityActionTypesFilter instance, DocumentActivityActionTypesFilterBuilder<?, ?> b) {
            b.type(instance.type);
            b.subtypes(instance.subtypes);
        }

        protected abstract B self();

        public abstract C build();

        public B type(String type) {
            this.type = type;
            return this.self();
        }

        public B subtypes(List<String> subtypes) {
            this.subtypes = subtypes;
            return this.self();
        }

        public String toString() {
            return "DocumentActivityActionTypesFilter.DocumentActivityActionTypesFilterBuilder(type=" + this.type + ", subtypes=" + this.subtypes + ")";
        }
    }
}

