/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model.presenter;

import com.comalatech.confluence.workflowreports.model.WorkflowApprovalsReportOptions;
import com.comalatech.confluence.workflowreports.model.presenter.MacroParametersPresenter;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlGroup;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlOperators;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlParam;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlPrintable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowApprovalsReportOptionsCqlPresenter
implements MacroParametersPresenter {
    private static final Logger log = LoggerFactory.getLogger(WorkflowApprovalsReportOptionsCqlPresenter.class);
    private final WorkflowApprovalsReportOptions options;
    private final ObjectMapper objectMapper;
    private static final String SPACE_NAME = "space";
    private static final String PARENT_NAME = "parent";
    private static final String LABEL_NAME = "label";
    private static final String STATES_NAME = "state";
    private static final String WORKFLOW_NAME = "workflowname";
    private static final String CQL_KEY = "cqlQuery";
    private static final String SHOW_LIVE_FILTERING_KEY = "showLiveFiltering";
    private static final String ITEMS_PER_PAGE_KEY = "numberOfItems";
    private static final String PRE_SELECTED_STATES_KEY = "preSelectedStates";
    private static final String PRE_SELECTED_WORKFLOWS_KEY = "preSelectedWorkflows";
    private static final String COLUMNS_TO_SHOW_KEY = "columnsToShow";
    private static final String ASSIGNEE_KEY = "assignee";
    private static final String APPROVAL_NAME = "approvalName";
    private static final String APPROVAL_STATUS = "approvalStatus";

    public WorkflowApprovalsReportOptionsCqlPresenter(WorkflowApprovalsReportOptions options, ObjectMapper objectMapper) {
        this.options = options;
        this.objectMapper = objectMapper;
    }

    @Override
    public Map<String, Object> present() {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put(ITEMS_PER_PAGE_KEY, this.options.getNumberOfItemsPerPage());
        propertiesMap.put(COLUMNS_TO_SHOW_KEY, this.options.getColumnsToShow());
        propertiesMap.put(ASSIGNEE_KEY, this.options.getAssignee());
        propertiesMap.put(APPROVAL_NAME, this.options.getApprovalName());
        propertiesMap.put(APPROVAL_STATUS, this.options.getApprovalStatus());
        propertiesMap.putAll(this.propertiesForLiveFiltering());
        propertiesMap.putAll(this.propertiesForCql());
        return propertiesMap;
    }

    private HashMap<String, Object> propertiesForLiveFiltering() {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        boolean enableLiveFilter = this.options.isSingleSpace();
        propertiesMap.put(SHOW_LIVE_FILTERING_KEY, enableLiveFilter);
        propertiesMap.put(PRE_SELECTED_STATES_KEY, this.toJson(enableLiveFilter ? this.options.getStates() : null));
        propertiesMap.put(PRE_SELECTED_WORKFLOWS_KEY, this.toJson(enableLiveFilter ? this.options.getWorkflows() : null));
        return propertiesMap;
    }

    private String toJson(Object parameter) {
        if (parameter != null) {
            try {
                return this.objectMapper.writeValueAsString(parameter);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return "";
    }

    private Map<String, String> propertiesForCql() {
        CqlGroup cqlGroup = new CqlGroup().joinOperator(CqlOperators.LogicalOperators.AND).addCqlElement(this.buildSimpleCqlParam(SPACE_NAME, this.options.getSpaceKeys())).addCqlElement(this.buildSimpleCqlParam(PARENT_NAME, this.options.getParentPageId())).addCqlElement(this.buildLabelsCqlParam());
        if (!this.options.isSingleSpace()) {
            cqlGroup.addCqlElement(this.buildSimpleCqlParam(STATES_NAME, this.options.getStates()));
            cqlGroup.addCqlElement(this.buildSimpleCqlParam(WORKFLOW_NAME, this.options.getWorkflows()));
        }
        if (this.options.getCql() != null) {
            String cql = this.options.getCql();
            String result = cqlGroup.toCqlString();
            if (result.isEmpty()) {
                result = cql;
            } else if (!cql.isEmpty()) {
                result = result + " AND " + cql;
            }
            return Collections.singletonMap(CQL_KEY, result);
        }
        if (this.options.getCqlFilters() != null) {
            this.options.getCqlFilters().forEach(field -> cqlGroup.addCqlElement(this.buildSimpleCqlParam(field.getName(), field.getValue())));
        }
        return Collections.singletonMap(CQL_KEY, cqlGroup.toCqlString());
    }

    private CqlPrintable buildLabelsCqlParam() {
        CqlPrintable labelsCql;
        if (this.options.isAllLabelsMandatory()) {
            CqlGroup labelsGroup = new CqlGroup();
            for (String label : this.options.getLabels()) {
                labelsGroup.addCqlElement(this.buildSimpleCqlParam(LABEL_NAME, label));
            }
            labelsCql = labelsGroup;
        } else {
            labelsCql = this.buildSimpleCqlParam(LABEL_NAME, this.options.getLabels());
        }
        return labelsCql;
    }

    private CqlPrintable buildSimpleCqlParam(String name, String value) {
        if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)value)) {
            return new CqlParam(name, value);
        }
        return null;
    }

    private CqlPrintable buildSimpleCqlParam(String name, List<String> values) {
        List notEmptyValues = values.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)name) && !notEmptyValues.isEmpty()) {
            return new CqlParam(name, values);
        }
        return null;
    }
}

