/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.services;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflowcontainer.services.LinkWorkflowToSpaceCategoryService;
import com.comalatech.confluence.workflowcontainer.services.LinkWorkflowToSpaceCategorySpacesTask;
import com.comalatech.workflow.template.LinkedTemplateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultLinkWorkflowToSpaceCategoryService
implements LinkWorkflowToSpaceCategoryService {
    private final LinkedTemplateManager linkedTemplateManager;
    private final TransactionTemplate transactionTemplate;
    private final WorkflowService workflowService;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final LongRunningTaskManager longRunningTaskManager;
    private final LabelManager labelManager;
    private final ComalaI18nBean comalaI18nBean;

    public DefaultLinkWorkflowToSpaceCategoryService(LinkedTemplateManager linkedTemplateManager, TransactionTemplate transactionTemplate, WorkflowService workflowService, WorkflowConfigurationManager workflowConfigurationManager, LongRunningTaskManager longRunningTaskManager, LabelManager labelManager, ComalaI18nBean comalaI18nBean) {
        this.linkedTemplateManager = linkedTemplateManager;
        this.transactionTemplate = transactionTemplate;
        this.workflowService = workflowService;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.longRunningTaskManager = longRunningTaskManager;
        this.labelManager = labelManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public LongRunningTaskId startSpacesLinkedToWorkflowTask(String workflowHandle, List<String> spaceKeys) {
        LinkWorkflowToSpaceCategorySpacesTask task = new LinkWorkflowToSpaceCategorySpacesTask(workflowHandle, this.linkedTemplateManager, spaceKeys, this.transactionTemplate, this.workflowService, this.workflowConfigurationManager, this.comalaI18nBean);
        return this.longRunningTaskManager.startLongRunningTask((User)AuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
    }

    @Override
    public Label getSpaceCategoryLabel(String spaceCategoryLabelName) {
        return this.labelManager.getLabel("team:" + spaceCategoryLabelName);
    }

    @Override
    public List<Space> getSpacesToBeLinkedToAGlobalWorkflow(String workflowHandle, Label spaceCategoryLabel) {
        List spacesFromCategory = this.labelManager.getSpacesWithLabel(spaceCategoryLabel);
        List<String> spacesAlreadyLinked = this.linkedTemplateManager.getLinkedSpaces(this.workflowService.getNameFromHandle(null, workflowHandle));
        return Optional.ofNullable(spacesFromCategory).map(list -> list.stream().filter(space -> spacesAlreadyLinked.stream().noneMatch(l -> l.equals(space.getKey()))).filter(space -> this.workflowConfigurationManager.getConfiguration().isSpaceWorkflowsAllowed(space.getKey())).collect(Collectors.toList())).orElse(new ArrayList());
    }
}

