/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.resources;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.onboard.OnboardingManager;
import com.comalatech.confluence.util.RestCommand;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/onboard")
public class OnboardingResource {
    private static final Logger log = LoggerFactory.getLogger(OnboardingResource.class);
    private final OnboardingManager onboardingManager;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final PermissionManager permissionManager;

    public OnboardingResource(OnboardingManager onboardingManager, WorkflowsFeatureManager workflowsFeatureManager, PermissionManager permissionManager) {
        this.onboardingManager = onboardingManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.permissionManager = permissionManager;
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/hide")
    @POST
    public Response hideOnboardPanel() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        try {
            this.onboardingManager.savePageHideCheck(user);
        }
        catch (Exception e) {
            log.error("Error saving onboarding Do Not Show flag for user {0} , {}", (Object)user, (Object)e);
            return Response.serverError().build();
        }
        return Response.created((URI)URI.create("")).build();
    }

    @GET
    @Path(value="/getspaces")
    @Produces(value={"application/json"})
    public Response getSpacesForUser() {
        return new RestCommand(this.workflowsFeatureManager, this.permissionManager){

            @Override
            public Response doExecute() {
                return Response.ok(OnboardingResource.this.onboardingManager.getSpacesForCurrentUser()).build();
            }
        }.execute();
    }
}

