/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.resources;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhocworkflows.rest.AbstractContentWorkflowResources;
import com.comalatech.confluence.adhocworkflows.rest.AbstractRestResources;
import com.comalatech.confluence.adhocworkflows.rest.model.Approval;
import com.comalatech.confluence.adhocworkflows.rest.model.WorkflowAction;
import com.comalatech.confluence.adhocworkflows.rest.permissions.EditPagePermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.ViewWorkflowPermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowVisibilityPermissionsRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsLiteAppRequired;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ApprovalRolesManager;
import com.comalatech.confluence.workflow.DefaultApprovalRolesManager;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.esignatures.configuration.ESignaturesConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.service.ESignaturesService;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflow.rest.accessor.ContentWorkflowAccessor;
import com.comalatech.confluence.workflow.rest.annotation.PATCH;
import com.comalatech.confluence.workflow.rest.model.ContentAction;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowApprovalAssignmentOperation;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowApprovalOperation;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowParameterOperation;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowResponse;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowStateExpirationOperation;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowStateOperation;
import com.comalatech.confluence.workflow.rest.model.Message;
import com.comalatech.confluence.workflow.rest.model.WorkflowParametersResponse;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.ApprovalService;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.WorkflowHandler;
import com.comalatech.workflow.model.Assignee;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import com.webcohesion.enunciate.metadata.Facet;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/content")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ContentWorkflowResources
extends AbstractContentWorkflowResources {
    private static final Logger log = LoggerFactory.getLogger(ContentWorkflowResources.class);
    private final ContentWorkflowAccessor contentWorkflowAccessor;
    private final DarkFeatureManager darkFeatureManager;
    private final UsersListResolver usersListResolver;
    private final ApprovalRolesManager approvalRolesManager;
    private final AdhocWorkflowsLicenseManager licenseManager;
    private final ApprovalService approvalService;
    private final StateService stateService;
    private final WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;

    public ContentWorkflowResources(PageManager pageManager, PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, AccessModeService accessModeService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowHandler workflowHandler, UserSearchManager userSearchManager, BootstrapManager bootstrapManager, WikiStyleRenderer wikiStyleRenderer, InternalWorkflowParameterManager workflowParameterManager, AdhocWorkflowManager adhocWorkflowManager, WorkflowTemplateManager workflowTemplateManager, WorkflowAccessor workflowAccessor, WorkflowContainerManager workflowContainerManager, ContentWorkflowAccessor contentWorkflowAccessor, DarkFeatureManager darkFeatureManager, UsersListResolver usersListResolver, ApprovalRolesManager approvalRolesManager, @Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager, ApprovalService approvalService, StateService stateService, ESignaturesConfigurationManager eSignaturesConfigurationManager, ESignaturesService eSignaturesService, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager, DefaultApprovalRolesManager defaultApprovalRolesManager, ComalaI18nBean comalaI18nBean) {
        super(pageManager, permissionManager, workflowPermissionManager, spaceManager, spacePermissionManager, accessModeService, workflowsFeatureManager, workflowConfigurationManager, workflowHandler, userSearchManager, bootstrapManager, wikiStyleRenderer, workflowParameterManager, adhocWorkflowManager, workflowTemplateManager, workflowAccessor, workflowContainerManager, eSignaturesConfigurationManager, eSignaturesService, defaultApprovalRolesManager, comalaI18nBean);
        this.contentWorkflowAccessor = contentWorkflowAccessor;
        this.darkFeatureManager = darkFeatureManager;
        this.usersListResolver = usersListResolver;
        this.approvalRolesManager = approvalRolesManager;
        this.licenseManager = licenseManager;
        this.approvalService = approvalService;
        this.stateService = stateService;
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
    }

    @ViewWorkflowPermissionRequired
    @GET
    @Path(value="/{id}/status")
    @TypeHint(value=ContentWorkflowResponse.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Workflow status."), @ResponseCode(code=204, condition="If there is no workflow set on the page"), @ResponseCode(code=400, condition="Workflow error. Check messages"), @ResponseCode(code=401, condition="If client is not authenticated"), @ResponseCode(code=403, condition="If no workflow visibility permission on the page"), @ResponseCode(code=404, condition="If no valid page with such id.")})
    public Response getContentWorkflowStatus(@PathParam(value="id") Long id, final @QueryParam(value="admin") boolean admin, final @QueryParam(value="expand") String expand, final @QueryParam(value="publishedView") boolean publishedView) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) {
                return ContentWorkflowResources.this.getContentWorkflowStatus(page, admin, expand, publishedView);
            }
        }.execute(id);
    }

    private Response getContentWorkflowStatus(AbstractPage page, boolean admin, String expand, Boolean publishedView) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received rest request for contentWorkflowStatus(page:%s, admin:%b, expand: %s)", page != null ? page.getIdAsString() : "null", admin, expand));
        }
        if (this.licenseManager.isLicensed()) {
            PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
            if (pageWorkflows != null && !pageWorkflows.getWorkflows().isEmpty()) {
                WorkflowAction workflowAction = this.makeWorkflowAction(page, admin, true, publishedView);
                this.tryToExpandGroupMembers(workflowAction);
                if (workflowAction != null && workflowAction.getPageStatus() != null) {
                    ContentWorkflowResponse contentWorkflowResponse = this.contentWorkflowAccessor.makeContentWorkflowResponse(page, workflowAction, admin, expand);
                    log.debug("Returning successfully rest request for contentWorkflowStatus");
                    return Response.ok((Object)contentWorkflowResponse).build();
                }
            }
            return Response.noContent().build();
        }
        Message invalidLicenseErrorMessage = new Message();
        invalidLicenseErrorMessage.type = "Error";
        invalidLicenseErrorMessage.closeable = true;
        invalidLicenseErrorMessage.title = this.comalaI18nBean.getText("approvalsworkflow.license.invalid");
        invalidLicenseErrorMessage.html = this.licenseManager.getLicenseStatus().getMessageHtml();
        ContentWorkflowResponse response = new ContentWorkflowResponse();
        response.messages = Collections.singletonList(invalidLicenseErrorMessage);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
    }

    private void tryToExpandGroupMembers(WorkflowAction workflowAction) {
        int limit;
        int n = limit = this.darkFeatureManager.isFeatureEnabledForAllUsers("comalatech.workflows.max.group.members.test") ? 3 : this.workflowAdvancedConfigurationManager.getMaxAllowedApproversToShow();
        if (workflowAction.getApprovals() != null) {
            for (Approval approval : workflowAction.getApprovals()) {
                if (!StringUtils.isBlank((CharSequence)approval.getFilterUsers()) || !StringUtils.isNotBlank((CharSequence)approval.getFilterGroups())) continue;
                try {
                    String[] groups;
                    ArrayList<String> expandedGroupsMembers = new ArrayList<String>();
                    ArrayList<String> notExpandedGroups = new ArrayList<String>();
                    for (String groupName : groups = MiscUtils.splitAndTrim(approval.getFilterGroups())) {
                        List<String> expandedGroupMembers = this.usersListResolver.getUsersFromGroup(groupName, limit + 1);
                        if (expandedGroupMembers.size() <= limit) {
                            for (String member : expandedGroupsMembers) {
                                expandedGroupMembers.remove(member);
                            }
                            expandedGroupsMembers.addAll(expandedGroupMembers);
                        } else {
                            notExpandedGroups.add(groupName);
                        }
                        if (expandedGroupsMembers.size() > limit) break;
                    }
                    if (expandedGroupsMembers.size() > limit) continue;
                    approval.setExpandedGroupsMembers(String.join((CharSequence)",", expandedGroupsMembers), String.join((CharSequence)",", notExpandedGroups));
                }
                catch (Exception exception) {}
            }
        }
    }

    @GET
    @Path(value="/{id}/messages")
    public Response getContentMessages(@PathParam(value="id") Long id) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) {
                return ContentWorkflowResources.this.getContentMessages(page);
            }
        }.execute(id);
    }

    private Response getContentMessages(AbstractPage page) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received rest request for contentMessages(page:%s)", page != null ? page.getIdAsString() : "null"));
        }
        if (this.licenseManager.isLicensed()) {
            WorkflowAction workflowAction;
            PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
            if (pageWorkflows != null && !pageWorkflows.getWorkflows().isEmpty() && (workflowAction = this.makeWorkflowAction(page, false, true, true)) != null && workflowAction.getPageStatus() != null) {
                log.debug("Returning successfully rest request for contentMessages");
                return Response.ok(workflowAction.getPageStatus().getMessages()).build();
            }
            return Response.noContent().build();
        }
        Message invalidLicenseErrorMessage = new Message();
        invalidLicenseErrorMessage.type = "Error";
        invalidLicenseErrorMessage.closeable = true;
        invalidLicenseErrorMessage.title = this.comalaI18nBean.getText("approvalsworkflow.license.invalid");
        invalidLicenseErrorMessage.html = this.licenseManager.getLicenseStatus().getMessageHtml();
        ContentWorkflowResponse response = new ContentWorkflowResponse();
        response.messages = Collections.singletonList(invalidLicenseErrorMessage);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)response).build();
    }

    @ReadOnlyAccessBlocked
    @PATCH
    @Path(value="/{id}/approvals/approve")
    @TypeHint(value=ContentWorkflowResponse.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Workflow status."), @ResponseCode(code=400, condition="There was an error in request, such as bad credentials when required, etc.  The detail of the error will be provided as messages"), @ResponseCode(code=401, condition="If client is not authenticated"), @ResponseCode(code=403, condition="If no workflow visibility permission on the page"), @ResponseCode(code=404, condition="If no valid page with such id.")})
    @ViewWorkflowPermissionRequired
    public Response approve(final @PathParam(value="id") Long id, final @QueryParam(value="expand") String expand, final ContentWorkflowApprovalOperation request) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) throws WorkflowException {
                ContentWorkflowResources.this.updateParameters(page, request);
                ContentWorkflowResources.this.approvalService.approve((ContentEntityObject)page, request.name, request.user, request.password, request.comment);
                return ContentWorkflowResources.this.getContentWorkflowStatus(id, false, expand, false);
            }
        }.execute(id);
    }

    @PUT
    @Path(value="/{id}/approvals/approve")
    @Facet(value="ignore")
    public Response approvePut(@PathParam(value="id") Long id, @QueryParam(value="expand") String expand, ContentWorkflowApprovalOperation request) {
        return this.approve(id, expand, request);
    }

    @ReadOnlyAccessBlocked
    @PATCH
    @Path(value="/{id}/approvals/reject")
    @TypeHint(value=ContentWorkflowResponse.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Workflow status."), @ResponseCode(code=400, condition="There was an error in request, such as bad credentials when required, etc.  The detail of the error will be provided as messages"), @ResponseCode(code=401, condition="If client is not authenticated"), @ResponseCode(code=403, condition="If no workflow visibility permission on the page."), @ResponseCode(code=404, condition="If no valid page with such id.")})
    @ViewWorkflowPermissionRequired
    public Response reject(final @PathParam(value="id") Long id, final @QueryParam(value="expand") String expand, final ContentWorkflowApprovalOperation request) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) throws WorkflowException {
                ContentWorkflowResources.this.updateParameters(page, request);
                ContentWorkflowResources.this.approvalService.reject((ContentEntityObject)page, request.name, request.user, request.password, request.comment);
                return ContentWorkflowResources.this.getContentWorkflowStatus(id, false, expand, false);
            }
        }.execute(id);
    }

    @PUT
    @Path(value="/{id}/approvals/reject")
    @Facet(value="ignore")
    public Response rejectPut(@PathParam(value="id") Long id, @QueryParam(value="expand") String expand, ContentWorkflowApprovalOperation request) {
        return this.reject(id, expand, request);
    }

    @ReadOnlyAccessBlocked
    @ViewWorkflowPermissionRequired
    @PATCH
    @Path(value="/{id}/approvals/assign")
    @TypeHint(value=ContentWorkflowResponse.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Workflow status."), @ResponseCode(code=400, condition="There was an error in request. The detail of the error will be provided as messages."), @ResponseCode(code=401, condition="If client is not authenticated"), @ResponseCode(code=403, condition="If no workflow visibility permission on the page."), @ResponseCode(code=404, condition="If no valid page with such id.")})
    public Response assign(final @PathParam(value="id") long id, final @QueryParam(value="expand") String expand, final ContentWorkflowApprovalAssignmentOperation request) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            public Response doInCommand(AbstractPage page) throws WorkflowException {
                ContentWorkflowResources.this.updateParameters(page, request);
                ArrayList<String> approvalRoles = new ArrayList<String>();
                for (Assignee assignee : request.assignees) {
                    if (assignee.rolename != null) {
                        ContentWorkflowResources.this.validateRolename(assignee);
                    }
                    ContentWorkflowResources.this.approvalService.assign((ContentEntityObject)page, request.name, assignee, request.comment);
                    if (!StringUtils.isNotBlank((CharSequence)assignee.rolename)) continue;
                    approvalRoles.add(assignee.rolename);
                }
                ContentWorkflowResources.this.approvalRolesManager.updateApprovalRoles(page.getSpaceKey(), approvalRoles);
                return ContentWorkflowResources.this.getContentWorkflowStatus(id, false, expand, false);
            }
        }.execute(id);
    }

    private void validateRolename(Assignee assignee) throws WorkflowUserException {
        if (StringUtils.isNotBlank((CharSequence)assignee.rolename)) {
            if (this.rolenameIsLongerThanMaxLength(assignee.rolename, 30)) {
                throw new WorkflowUserException(this.comalaI18nBean.getText("approvalsworkflow.workflow.rolename.maxlength.error", new Object[]{assignee.username, 30}));
            }
            if (this.rolenameContainsSpecialCharacters(assignee.rolename)) {
                throw new WorkflowUserException(this.comalaI18nBean.getText("approvalsworkflow.workflow.rolename.specialcharacters.error", new Object[]{assignee.username}));
            }
        }
    }

    private boolean rolenameIsLongerThanMaxLength(String rolename, int maxApprovalRolesChars) {
        return rolename.length() > maxApprovalRolesChars;
    }

    private boolean rolenameContainsSpecialCharacters(String rolename) {
        return rolename.contains("<") || rolename.contains(">") || rolename.contains("\"") || rolename.contains("'") || rolename.contains("&");
    }

    @PUT
    @Path(value="/{id}/approvals/assign")
    @Facet(value="ignore")
    public Response assignPut(@PathParam(value="id") long id, @QueryParam(value="expand") String expand, ContentWorkflowApprovalAssignmentOperation request) {
        return this.assign(id, expand, request);
    }

    @ReadOnlyAccessBlocked
    @ViewWorkflowPermissionRequired
    @PATCH
    @Path(value="/{id}/approvals/unassign")
    @TypeHint(value=ContentWorkflowResponse.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Workflow status."), @ResponseCode(code=400, condition="There was an error in request. The detail of the error will be provided as messages."), @ResponseCode(code=401, condition="If client is not authenticated"), @ResponseCode(code=403, condition="If no workflow visibility permission on the page."), @ResponseCode(code=404, condition="If no valid page with such id.")})
    public Response unassign(final @PathParam(value="id") long id, final @QueryParam(value="expand") String expand, final ContentWorkflowApprovalAssignmentOperation request) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            public Response doInCommand(AbstractPage page) throws WorkflowException {
                ContentWorkflowResources.this.updateParameters(page, request);
                for (Assignee assignee : request.assignees) {
                    ContentWorkflowResources.this.approvalService.unassign((ContentEntityObject)page, request.name, assignee.username, request.comment);
                }
                return ContentWorkflowResources.this.getContentWorkflowStatus(id, false, expand, false);
            }
        }.execute(id);
    }

    @PUT
    @Path(value="/{id}/approvals/unassign")
    @Facet(value="ignore")
    public Response unassignPut(@PathParam(value="id") long id, @QueryParam(value="expand") String expand, ContentWorkflowApprovalAssignmentOperation request) {
        return this.unassign(id, expand, request);
    }

    @WorkflowVisibilityPermissionsRequired
    @PUT
    @Path(value="/{id}/state")
    @TypeHint(value=ContentWorkflowResponse.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Workflow status."), @ResponseCode(code=400, condition="There was an error in request. The detail of the error will be provided as messages."), @ResponseCode(code=401, condition="If client is not authenticated"), @ResponseCode(code=403, condition="If no View permission on the page."), @ResponseCode(code=404, condition="If no valid page with such id.")})
    public Response changeState(final @PathParam(value="id") long id, final @QueryParam(value="expand") String expand, final @QueryParam(value="admin") boolean admin, final ContentWorkflowStateOperation request) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            public Response doInCommand(AbstractPage page) throws WorkflowException {
                ContentWorkflowResources.this.updateParameters(page, request);
                ContentWorkflowResources.this.stateService.setState((ContentEntityObject)page, request.name, request.comment);
                return ContentWorkflowResources.this.getContentWorkflowStatus(id, admin, expand, false);
            }
        }.execute(id);
    }

    @ReadOnlyAccessBlocked
    @WorkflowVisibilityPermissionsRequired
    @PATCH
    @Path(value="/{id}/expirydate")
    @TypeHint(value=ContentWorkflowResponse.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Workflow status."), @ResponseCode(code=400, condition="There was an error in request. The detail of the error will be provided as messages."), @ResponseCode(code=401, condition="If client is not authenticated"), @ResponseCode(code=403, condition="If no View permission on the page."), @ResponseCode(code=404, condition="If no valid page with such id.")})
    public Response updateExpiryDate(final @PathParam(value="id") long id, final @QueryParam(value="admin") boolean admin, final @QueryParam(value="expand") String expand, final ContentWorkflowStateExpirationOperation request) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            public Response doInCommand(AbstractPage page) throws WorkflowException {
                ContentWorkflowResources.this.stateService.updateExpiryDate((ContentEntityObject)page, ContentWorkflowResources.this.parseDate(request.expiry));
                return ContentWorkflowResources.this.getContentWorkflowStatus(id, admin, expand, false);
            }
        }.execute(id);
    }

    @PUT
    @Path(value="/{id}/expirydate")
    @Facet(value="ignore")
    public Response updateExpiryDatePut(@PathParam(value="id") long id, @QueryParam(value="admin") boolean admin, @QueryParam(value="expand") String expand, ContentWorkflowStateExpirationOperation request) {
        return this.updateExpiryDate(id, admin, expand, request);
    }

    @EditPagePermissionRequired
    @WorkflowsAppRequired
    @WorkflowsLiteAppRequired
    @PUT
    @Path(value="/{id}/parameters")
    @TypeHint(value=ContentWorkflowResponse.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Workflow status."), @ResponseCode(code=400, condition="There was an error in request. The detail of the error will be provided as messages."), @ResponseCode(code=401, condition="If client is not authenticated"), @ResponseCode(code=403, condition="If no edit page permission"), @ResponseCode(code=404, condition="If no valid page with such id or no view permission on the page.")})
    public Response updateParameters(final @PathParam(value="id") long id, final @QueryParam(value="expand") String expand, final Map<String, String> parameters) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            public Response doInCommand(AbstractPage page) throws WorkflowException {
                for (String parameterId : parameters.keySet()) {
                    ContentWorkflowResources.this.workflowHandler.setParameter((ContentEntityObject)page, parameterId, (String)parameters.get(parameterId));
                }
                return ContentWorkflowResources.this.getContentWorkflowStatus(id, false, expand, false);
            }
        }.execute(id);
    }

    @WorkflowVisibilityPermissionsRequired
    @WorkflowsAppRequired
    @WorkflowsLiteAppRequired
    @GET
    @Path(value="/{id}/parameters")
    @TypeHint(value=WorkflowParametersResponse.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Page Editable Workflow Parameters"), @ResponseCode(code=204, condition="There are no editable workflow parameters in the page"), @ResponseCode(code=401, condition="If client is not authenticated"), @ResponseCode(code=403, condition="If no edit page permission"), @ResponseCode(code=404, condition="If no valid page with such id or no view permission on the page.")})
    public Response getParameters(@PathParam(value="id") long id) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            public Response doInCommand(AbstractPage page) throws WorkflowException {
                WorkflowAction workflowAction = ContentWorkflowResources.this.makeWorkflowAction(page, false, false, false);
                if (workflowAction != null && workflowAction.getPageStatus() != null) {
                    ContentWorkflowResponse contentWorkflowResponse = ContentWorkflowResources.this.contentWorkflowAccessor.makeContentWorkflowResponse(page, workflowAction, false, "actions");
                    for (ContentAction action : contentWorkflowResponse.actions) {
                        if (!action.type.equals("parameters")) continue;
                        ContentAction.ParametersAction parameterAction = (ContentAction.ParametersAction)action;
                        return Response.ok((Object)new WorkflowParametersResponse(parameterAction.inputFields)).build();
                    }
                }
                return Response.noContent().build();
            }
        }.execute(id);
    }

    @Override
    protected Response getStatus(AbstractPage page, Message errorMessage) {
        WorkflowAction workflowAction = this.makeWorkflowAction(page, false, true, false);
        if (errorMessage != null && workflowAction.getPageStatus() != null) {
            workflowAction.getPageStatus().addMessage(errorMessage);
        }
        ContentWorkflowResponse contentWorkflowResponse = this.contentWorkflowAccessor.makeContentWorkflowResponse(page, workflowAction, false, "state,states,approvals");
        return Response.status((Response.Status)(errorMessage == null ? Response.Status.OK : Response.Status.BAD_REQUEST)).entity((Object)contentWorkflowResponse).build();
    }

    private void updateParameters(AbstractPage page, ContentWorkflowParameterOperation op) throws WorkflowException {
        if (op != null && op.parameters != null) {
            for (ContentWorkflowParameterOperation.Parameter p : op.parameters) {
                this.workflowHandler.setParameter((ContentEntityObject)page, p.id, p.value);
            }
        }
    }

    private Date parseDate(Long date) {
        return date != null ? new Date(date) : null;
    }
}

