/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.permissions;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;

public class DefaultWorkflowPermissionManager
implements WorkflowPermissionManager {
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final PermissionManager permissionManager;
    private final SpacePermissionManager spacePermissionManager;
    private final AccessModeService accessModeService;

    public DefaultWorkflowPermissionManager(WorkflowConfigurationManager workflowConfigurationManager, PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, AccessModeService accessModeService) {
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.permissionManager = permissionManager;
        this.spacePermissionManager = spacePermissionManager;
        this.accessModeService = accessModeService;
    }

    @Override
    public boolean canViewDrafts(AbstractPage page, ConfluenceUser user) {
        if (page != null) {
            String spaceKey = page.isLatestVersion() ? page.getSpaceKey() : page.getLatestVersion().getSpaceKey();
            WorkflowVisibilityInternal visibility = this.workflowConfigurationManager.getHistoryVisibility(spaceKey, true);
            if (WorkflowVisibilityInternal.ANY.equals((Object)visibility)) {
                return this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)page);
            }
            if (WorkflowVisibilityInternal.CONTRIBUTORS.equals((Object)visibility)) {
                try {
                    return this.canEdit(user, page) || this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", page.getSpace(), (User)user) || this.permissionManager.isConfluenceAdministrator((User)user);
                }
                catch (ServiceException e) {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean canEdit(ConfluenceUser user, AbstractPage page) {
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption(() -> this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page));
    }

    private boolean canEditAndCreate(ConfluenceUser user, Space space) {
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption(() -> this.spacePermissionManager.hasPermission("EDITSPACE", space, (User)user) || this.spacePermissionManager.hasPermission("EDITBLOG", space, (User)user));
    }

    @Override
    public boolean canViewWorkflows(Space space, ConfluenceUser user) {
        if (space != null) {
            WorkflowVisibilityInternal visibility = this.workflowConfigurationManager.getHistoryVisibility(space.getKey(), true);
            if (WorkflowVisibilityInternal.ANY.equals((Object)visibility)) {
                return this.spacePermissionManager.hasPermission("VIEWSPACE", space, (User)user);
            }
            if (WorkflowVisibilityInternal.CONTRIBUTORS.equals((Object)visibility)) {
                return this.canEditAndCreate(user, space) || this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)user) || this.permissionManager.isConfluenceAdministrator((User)user);
            }
        }
        return false;
    }

    @Override
    public boolean canAddSpaceWorkflows(Space space, ConfluenceUser user) {
        if (space != null) {
            return this.workflowConfigurationManager.getConfiguration().isSpaceWorkflowsAllowed(space.getKey()) && (this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)user) || this.permissionManager.isConfluenceAdministrator((User)user));
        }
        return false;
    }

    @Override
    public boolean canAdministerSpace(Space space, ConfluenceUser user) {
        return this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)user);
    }

    @Override
    public boolean canAdministerConfluence(ConfluenceUser user) {
        return this.permissionManager.isConfluenceAdministrator((User)user);
    }
}

