/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork.notification.state;

import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.states.event.StateTransitionEvent;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.mywork.notification.state.AbstractStateNotification;
import com.comalatech.workflow.event.StateChangeEvent;
import org.apache.commons.lang3.StringUtils;

public class StateChangeNotification
extends AbstractStateNotification {
    protected StateChangeEvent event;

    public StateChangeNotification(StateChangeEvent event) {
        super(event);
        this.event = event;
    }

    @Override
    public String getItemTitle() {
        return ComalaI18nBean.getComalaI18nBean().getText("com.comalatech.confluence.workflow.mywork.state.changed.itemTitle", new String[]{this.page.getDisplayTitle(), this.event.getState().getName()});
    }

    @Override
    public String getDescription() {
        PageState pageState = ((StateTransitionEvent)this.event).getState();
        if (StringUtils.isNotBlank((CharSequence)pageState.getComment())) {
            return pageState.getComment();
        }
        return "";
    }

    @Override
    public String getAction() {
        return "changed";
    }

    @Override
    public String getIconUrlPath() {
        return "/download/resources/com.comalatech.workflow/images/workflow.gif";
    }

    @Override
    public String globalId() {
        return this.page.getIdAsString() + "-statechanged-" + this.event.getState().getName();
    }

    @Override
    public String getGroupingId() {
        return this.page.getIdAsString() + "-statechanged";
    }
}

