/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Selector
implements Serializable {
    public static final int ANY_CANAPPROVE = 0;
    public static final int ONE_CANAPPROVE = 1;
    public static final int ONE_OR_MANY_CANAPPROVE = 2;
    public static final int ALL_MUSTAPPROVE = 3;
    public static final Selector DEFAULT_SELECTOR = new Selector("", 0, "0");
    private String approvalName;
    private String caption;
    private String hint;
    private String users;
    private String minimum;
    private int type;

    public Selector(String users, int type) {
        this(users, type, "1");
    }

    public Selector(String users, int type, String minimum) {
        this.users = users;
        this.type = type;
        this.minimum = minimum;
    }

    public String getApprovalName() {
        return this.approvalName;
    }

    public void setApprovalName(String approvalName) {
        this.approvalName = approvalName;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setMinimum(String minimum) {
        try {
            int minimumNumerical = Double.valueOf(minimum).intValue();
            if (minimumNumerical > 0) {
                this.minimum = minimum;
            }
        }
        catch (NumberFormatException e) {
            this.minimum = minimum;
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getUsers() {
        return this.users;
    }

    public String[] getUsersAsArray() {
        return this.users.split(",");
    }

    public boolean isAnyCanApprove() {
        return this.type == 0;
    }

    public boolean isSelectMultiple() {
        return this.type == 2;
    }

    public boolean isSelectOne() {
        return this.type == 1;
    }

    public boolean isAllMustApprove() {
        return this.type == 3;
    }

    public int getType() {
        return this.type;
    }

    public String getMinimum() {
        return this.minimum;
    }

    public boolean isSelection() {
        return this.type == 1 || this.type == 2;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Selector)) {
            return false;
        }
        Selector s = (Selector)o;
        return (this.caption == s.caption || this.caption != null && this.caption.equals(s.caption)) && this.type == s.type && (this.users == s.caption || this.users != null && this.users.equals(s.users));
    }
}

