/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Entity;
import com.atlassian.user.Group;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ApprovalStatus {
    public static final ApprovalStatus NOT_READY = new ApprovalStatus(false, false);
    public static final String[] EMTY_ARRAY = new String[0];
    private boolean ready;
    private boolean canApprove;
    private boolean isAllowedToAssign;
    private String precedingApprovalsNames;
    private String[] requiredApprovers;
    private Collection<ConfluenceUser> possibleUserApprovers;
    private Collection<Group> possibleGroupApprovers;
    private Collection<ConfluenceUser> excludedUserApprovers;

    public ApprovalStatus(boolean ready, boolean canApprove) {
        this(ready, canApprove, false);
    }

    public ApprovalStatus(boolean ready, boolean canApprove, boolean isAllowedToAssign) {
        this.ready = ready;
        this.canApprove = canApprove;
        this.isAllowedToAssign = isAllowedToAssign;
        this.requiredApprovers = EMTY_ARRAY;
        this.possibleUserApprovers = new ArrayList<ConfluenceUser>();
        this.possibleGroupApprovers = new ArrayList<Group>();
        this.excludedUserApprovers = new ArrayList<ConfluenceUser>();
        this.precedingApprovalsNames = "";
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public boolean isCanApprove() {
        return this.ready && this.canApprove;
    }

    public void setCanApprove(boolean canApprove) {
        this.canApprove = this.ready && canApprove;
    }

    public boolean isAllowedToAssign() {
        return this.isAllowedToAssign;
    }

    public void setAllowedToAssign(boolean allowedToAssign) {
        this.isAllowedToAssign = allowedToAssign;
    }

    public String getPrecedingApprovalsNames() {
        return this.precedingApprovalsNames;
    }

    public void setPrecedingApprovalsNames(String precedingApprovalsNames) {
        this.precedingApprovalsNames = precedingApprovalsNames;
    }

    public String[] getRequiredApprovers() {
        return this.requiredApprovers;
    }

    public void setRequiredApprovers(String[] requiredApprovers) {
        this.requiredApprovers = requiredApprovers;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApprovalStatus that = (ApprovalStatus)o;
        if (this.canApprove != that.canApprove) {
            return false;
        }
        if (this.ready != that.ready) {
            return false;
        }
        return !(this.precedingApprovalsNames != null ? !this.precedingApprovalsNames.equals(that.precedingApprovalsNames) : that.precedingApprovalsNames != null);
    }

    public int hashCode() {
        int result = this.ready ? 1 : 0;
        result = 31 * result + (this.canApprove ? 1 : 0);
        result = 31 * result + (this.precedingApprovalsNames != null ? this.precedingApprovalsNames.hashCode() : 0);
        return result;
    }

    public Collection<ConfluenceUser> getPossibleUserApprovers() {
        return this.possibleUserApprovers;
    }

    public Collection<String> getPossibleUserApproverNameStrings() {
        return this.getUserNameStrings(this.possibleUserApprovers);
    }

    public Collection<ConfluenceUser> getExcludedUserApprovers() {
        return this.excludedUserApprovers;
    }

    public Collection<String> getExcludedUserApproversNameStrings() {
        return this.getUserNameStrings(this.excludedUserApprovers);
    }

    private Collection<String> getUserNameStrings(Collection<ConfluenceUser> users) {
        ArrayList<String> userNames = new ArrayList<String>(users.size());
        for (ConfluenceUser user : users) {
            userNames.add(user.getName());
        }
        return userNames;
    }

    public void setPossibleUserApprovers(Collection<ConfluenceUser> possibleUserApprovers) {
        this.possibleUserApprovers = possibleUserApprovers;
    }

    public void addPossibleUserApprovers(Collection<ConfluenceUser> additionalUserApprovers) {
        this.possibleUserApprovers.addAll(additionalUserApprovers);
    }

    public void addExcludedUserApprovers(Collection<ConfluenceUser> excludedUsers) {
        this.excludedUserApprovers.addAll(excludedUsers);
    }

    public Collection<Group> getPossibleGroupApprovers() {
        return this.possibleGroupApprovers;
    }

    public Collection<String> getPossibleGroupApproverNameStrings() {
        ArrayList<String> groupNames = new ArrayList<String>(this.possibleGroupApprovers.size());
        for (Group group : this.possibleGroupApprovers) {
            groupNames.add(group.getName());
        }
        return groupNames;
    }

    public void setPossibleGroupApprovers(Collection<Group> possibleGroupApprovers) {
        this.possibleGroupApprovers = possibleGroupApprovers;
    }

    public void addPossibleGroupApprovers(Collection<Group> additionalGroupApprovers) {
        this.possibleGroupApprovers.addAll(additionalGroupApprovers);
    }

    public Collection<Entity> getPossibleApprovers() {
        ArrayList<Entity> possibleApprovers = new ArrayList<Entity>(this.possibleUserApprovers.size() + this.possibleGroupApprovers.size());
        possibleApprovers.addAll(this.possibleUserApprovers);
        possibleApprovers.addAll(this.possibleGroupApprovers);
        return possibleApprovers;
    }
}

