/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.extractors;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.PageStateTimer;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.tasks.model.PageTasks;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.Constants;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.confluence.workflow.model.DueDateRecordAware;
import com.comalatech.confluence.workflowreports.ActivityManager;
import com.comalatech.confluence.workflowreports.search.LuceneHelper;
import com.comalatech.workflow.StateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApprovalsExtractor
implements Extractor2 {
    private static final Logger log = LoggerFactory.getLogger(ApprovalsExtractor.class);
    private final ApprovalAccessor approvalAccessor;
    private final WorkflowAccessor workflowAccessor;
    private final StateService stateService;
    private final ActivityManager activityManager;
    private final AttachmentManager attachmentManager;

    public ApprovalsExtractor(ApprovalAccessor approvalAccessor, WorkflowAccessor workflowAccessor, StateService stateService, ActivityManager activityManager, AttachmentManager attachmentManager) {
        this.approvalAccessor = approvalAccessor;
        this.workflowAccessor = workflowAccessor;
        this.stateService = stateService;
        this.activityManager = activityManager;
        this.attachmentManager = attachmentManager;
    }

    public StringBuilder extractText(Object searchable) {
        return new StringBuilder();
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        boolean workflowActive = false;
        ArrayList<FieldDescriptor> fieldList = new ArrayList<FieldDescriptor>();
        if (!(searchable instanceof AbstractPage)) {
            return null;
        }
        AbstractPage page = (AbstractPage)searchable;
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        try {
            if (pageWorkflows != null && pageWorkflows.getFirstWorkflowWithStates() != null) {
                Date lastActivityDate;
                ConfluenceUser user;
                workflowActive = true;
                PageState pageState = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
                List<ApprovalCheck> approvalChecks = this.approvalAccessor.getLatestApprovalChecksForAnyState(page);
                for (ApprovalCheck approvalCheck : approvalChecks) {
                    boolean approvalUpToDate = approvalCheck.isCheckUpToDate(page, pageState, true, this.attachmentManager);
                    String key = approvalCheck.isApproved() ? "approved" : (approvalCheck.isRejected(true) ? "rejected" : "partial");
                    if (!(pageState != null && pageState.getId() != approvalCheck.getStateId() || approvalUpToDate)) {
                        fieldList.add(new FieldDescriptor("outdated", Constants.makeId(approvalCheck.getName()), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                    }
                    fieldList.add(new FieldDescriptor(key, Constants.makeId(approvalCheck.getName()), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                    fieldList.addAll(this.getApprovalAssigneesAndApproversFields(approvalCheck, approvalUpToDate, pageState));
                }
                if (pageState != null) {
                    fieldList.add(new FieldDescriptor("pagestate", Constants.makeId(pageState.getState().toLowerCase().replaceAll("_", " ")), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                    fieldList.add(new FieldDescriptor("pagestateName", pageState.getState().toLowerCase().replaceAll("_", " "), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                    fieldList.add(new FieldDescriptor("statechanged", LuceneHelper.luceneDateToMilliSeconds(pageState.getDate()), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                    if (pageState.getPerformer() != null) {
                        fieldList.add(new FieldDescriptor("statechangedby", pageState.getPerformer(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                    }
                    fieldList.addAll(this.getTaskFields(pageState));
                    fieldList.addAll(this.getTaskAssignees(pageState));
                    fieldList.addAll(this.getAssigneeFields(page.getSpaceKey(), pageState));
                    fieldList.addAll(this.getEarliestDueDateFields(pageState, page));
                    fieldList.addAll(this.getTimersVectorFields(page.getSpaceKey(), pageState.getTimers()));
                }
                HashSet<String> checkedApprovals = new HashSet<String>();
                List<ApprovalCheck> stateCheckedApprovals = this.approvalAccessor.getLatestApprovalChecks(page);
                for (ApprovalCheck approval : stateCheckedApprovals) {
                    checkedApprovals.add(approval.getName());
                }
                StatesContainer statesContainer = pageWorkflows.getStatesContainer();
                for (Approval approval : pageWorkflows.getApprovals(pageState)) {
                    if (checkedApprovals.contains(approval.getName())) continue;
                    fieldList.add(new FieldDescriptor("pending", Constants.makeId(approval.getName()), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                }
                fieldList.addAll(this.getWorkflowField(pageWorkflows));
                if (statesContainer != null) {
                    fieldList.add(this.getStateVectorField(page.getSpaceKey(), statesContainer));
                    fieldList.add(this.getStateVectorField(statesContainer));
                }
                if ((user = page.getLastModifier()) != null) {
                    String fullName = StringUtils.isNotBlank((CharSequence)user.getFullName()) ? user.getFullName() : user.getName();
                    fieldList.add(new FieldDescriptor("lastModifierDisplayName", fullName, FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                }
                if ((lastActivityDate = this.activityManager.getCachedRecentActivityDate(page)) != null) {
                    fieldList.add(new FieldDescriptor("lastworkflowactivity", LuceneHelper.luceneDateToSeconds(lastActivityDate), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                }
            }
            if (workflowActive) {
                fieldList.add(new FieldDescriptor("awpadhocworkflowctec", page.getIdAsString(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                fieldList.add(new FieldDescriptor("awphasworkflow", "true", FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                fieldList.add(new FieldDescriptor("awpadhocworkflowspaces", page.getSpaceKey(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                String workflowName = pageWorkflows.getFirstWorkflowWithStates().getName().toLowerCase();
                fieldList.add(new FieldDescriptor("workflownamehash", Constants.makeId(workflowName), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                fieldList.add(new FieldDescriptor("workflowname", workflowName, FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
            }
        }
        catch (Exception ex) {
            log.error("Error extracting fields: " + ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return fieldList;
    }

    private Collection<FieldDescriptor> getTimersVectorFields(String spaceKey, List<PageStateTimer> timers) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        if (timers.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (PageStateTimer timer : timers) {
                Date d = timer.getDueDate();
                String date = LuceneHelper.luceneDateToSeconds(d);
                fields.add(new FieldDescriptor(LuceneHelper.makeTimerFieldName(timer.getName()), date, FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                if (timer.isActive()) {
                    fields.add(new FieldDescriptor(LuceneHelper.makeActiveTimerFieldName(timer.getName()), date, FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                }
                sb.append(LuceneHelper.maskSpaces(timer.getName()));
            }
            fields.add(new FieldDescriptor(LuceneHelper.makeTimersVectorKey(spaceKey), sb.toString(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
        }
        return fields;
    }

    private Collection<FieldDescriptor> getEarliestDueDateFields(PageState pageState, AbstractPage page) {
        Date earliestDueDate = null;
        Date earliestActiveStateExpiration = null;
        Date stateExpiration = null;
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        List<PageTask> pageTasks = pageState.getTasks();
        Date earliestTaskDueDate = this.getEarliestDueDate(pageTasks);
        if (earliestTaskDueDate != null) {
            fields.add(new FieldDescriptor("earliestTaskDueDate", LuceneHelper.luceneDateToSeconds(earliestTaskDueDate), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
            earliestDueDate = earliestTaskDueDate;
        }
        List<PageStateTimer> pageStateTimers = pageState.getTimers();
        for (PageStateTimer timer : pageStateTimers) {
            if (timer.isActive() && (earliestActiveStateExpiration == null || earliestActiveStateExpiration.after(timer.getDueDate()))) {
                earliestActiveStateExpiration = timer.getDueDate();
            }
            if (stateExpiration != null && !stateExpiration.after(timer.getDueDate())) continue;
            stateExpiration = timer.getDueDate();
        }
        if (stateExpiration != null) {
            fields.add(new FieldDescriptor("nextexpiration", LuceneHelper.luceneDateToSeconds(stateExpiration), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
        }
        if (earliestActiveStateExpiration != null && (earliestDueDate == null || earliestActiveStateExpiration.before(earliestDueDate))) {
            earliestDueDate = earliestActiveStateExpiration;
        }
        if (earliestDueDate != null) {
            fields.add(new FieldDescriptor("earliestDueDate", LuceneHelper.luceneDateToSeconds(earliestDueDate), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
        }
        return fields;
    }

    private Date getEarliestDueDate(List<? extends DueDateRecordAware> dueDateRecords) {
        Date earliestDueDate = null;
        for (DueDateRecordAware dueDateRecordAware : dueDateRecords) {
            DueDateRecord dueDate = dueDateRecordAware.getCurrentDueDate();
            if (dueDate == null || dueDate.isExpiryTriggered() || earliestDueDate != null && (dueDate.getDueDate() == null || !dueDate.getDueDate().before(earliestDueDate))) continue;
            earliestDueDate = dueDate.getDueDate();
        }
        return earliestDueDate;
    }

    private Collection<FieldDescriptor> getTaskFields(PageState pageState) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        PageTasks.Stats stats = pageState.getPageTasks().getStats();
        if (stats.getTotal() > 0) {
            fields.add(new FieldDescriptor("hastasks", "true", FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
        }
        if (stats.getCompleted() > 0) {
            fields.add(new FieldDescriptor("completedtasks", "true", FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
        }
        if (stats.getOpen() > 0) {
            fields.add(new FieldDescriptor("activetasks", "true", FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
        }
        return fields;
    }

    private Collection<FieldDescriptor> getTaskAssignees(PageState pageState) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        for (PageTask task : pageState.getPageTasks().get()) {
            if (!StringUtils.isNotBlank((CharSequence)task.getAssignee())) continue;
            fields.add(new FieldDescriptor("taskAssignee", task.getAssignee(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
        }
        return fields;
    }

    private FieldDescriptor getAssigneesVectorField(String spaceKey, List<String> assignees) {
        StringBuilder sb = new StringBuilder();
        for (String assignee : assignees) {
            sb.append(' ').append(LuceneHelper.maskSpaces(assignee));
        }
        return new FieldDescriptor(LuceneHelper.makeAssigneesVectorKey(spaceKey), sb.toString(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED);
    }

    private Collection<FieldDescriptor> getAssigneeFields(String spaceKey, PageState pageState) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        List<String> assignees = pageState.getAllAssignees();
        fields.add(this.getAssigneesVectorField(spaceKey, assignees));
        for (String userName : assignees) {
            fields.add(new FieldDescriptor("assignee", userName, FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
        }
        return fields;
    }

    private Collection<FieldDescriptor> getApprovalAssigneesAndApproversFields(ApprovalCheck approval, boolean upToDate, PageState pageState) {
        List<String> assignees;
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        Approver[] approvers = approval.getApprovers();
        HashSet<String> approverNames = new HashSet<String>();
        if (approvers != null) {
            String approvalId = Constants.makeApprovalSelectionId(approval.getName());
            for (Approver approver : approvers) {
                approverNames.add(approver.getPerformer());
                fields.add(new FieldDescriptor(approvalId, approver.getPerformer(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
                fields.add(new FieldDescriptor("approver", approver.getPerformer(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
            }
        }
        if ((assignees = Arrays.asList(approval.getRequiredApprovers())).isEmpty() || approval.isApproved() && this.isNotLastApproval(approval, pageState)) {
            return fields;
        }
        for (String assignee : assignees) {
            if (approverNames.contains(assignee) && upToDate) continue;
            fields.add(new FieldDescriptor("assignee", assignee, FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
            fields.add(new FieldDescriptor("approvalAssignee", assignee, FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
        }
        return fields;
    }

    private boolean isNotLastApproval(ApprovalCheck approval, PageState pageState) {
        return pageState.getId() != approval.getStateId();
    }

    private Collection<FieldDescriptor> getWorkflowField(PageWorkflows workflows) {
        String[] ids;
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        for (String id : ids = workflows.getWorkflowIds()) {
            fields.add(new FieldDescriptor("workflowid", id, FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED));
        }
        return fields;
    }

    private FieldDescriptor getStateVectorField(String spaceKey, StatesContainer statesContainer) {
        StringBuilder sb = new StringBuilder();
        char ix = 'a';
        for (State state : statesContainer.getStates()) {
            String maskedState = LuceneHelper.maskSpaces(state.getName());
            sb.append(' ').append(ix).append(maskedState);
            ix = (char)(ix + '\u0001');
        }
        return new FieldDescriptor(LuceneHelper.makeStatesVectorKey(spaceKey), sb.toString().trim(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED);
    }

    private FieldDescriptor getStateVectorField(StatesContainer statesContainer) {
        StringBuilder sb = new StringBuilder();
        char ix = 'a';
        for (State state : statesContainer.getStates()) {
            String maskedState = LuceneHelper.maskSpaces(state.getName());
            sb.append(' ').append(ix).append(maskedState);
            ix = (char)(ix + '\u0001');
        }
        return new FieldDescriptor(LuceneHelper.getStatesVectorKey(), sb.toString().trim(), FieldDescriptor.Store.YES, FieldDescriptor.Index.NOT_ANALYZED);
    }
}

