/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.audit.dao;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.bandana.KeyedBandanaContext;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import com.comalatech.confluence.util.JsonSerialiserUtil;
import com.comalatech.confluence.workflow.audit.dao.WorkflowAuditLogDao;
import com.comalatech.confluence.workflow.audit.model.AuditLegacyRecord;
import com.comalatech.confluence.workflow.audit.model.WorkflowAuditLegacyRecord;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BandanaWorkflowAuditLogDao
implements WorkflowAuditLogDao {
    public static final String WORKFLOW_AUDIT_LOG_KEY = "com.comalatech.adocworkflows.auditlog";
    private final BandanaManager bandanaManager;
    private final JsonSerialiserUtil<WorkflowAuditLegacyRecord> auditRecordSerialiser = new JsonSerialiserUtil<WorkflowAuditLegacyRecord>(WorkflowAuditLegacyRecord.class);

    public BandanaWorkflowAuditLogDao(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @Override
    public List<AuditLegacyRecord> getAuditLogRecords(String spaceKey) {
        KeyedBandanaContext context = this.makeContext(spaceKey);
        String json = (String)this.bandanaManager.getValue((BandanaContext)context, WORKFLOW_AUDIT_LOG_KEY);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            ArrayList recordList = Lists.newArrayList();
            recordList.addAll(this.auditRecordSerialiser.deserialiseList(json));
            return recordList;
        }
        return Lists.newArrayList();
    }

    private KeyedBandanaContext makeContext(String spaceKey) {
        return StringUtils.isNotBlank((CharSequence)spaceKey) ? new ConfluenceBandanaContext(spaceKey) : ComalatechBandanaContext.COMALATECH_CONTEXT;
    }
}

