/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.cloud.migration.service.WorkflowsUsageReportService;
import com.comalatech.confluence.cloud.migration.service.model.WorkflowsUsageReport;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.analytics.DispatcherAnalyticsManager;
import com.comalatech.confluence.workflow.analytics.catalog.BandanaKeysCatalog;
import com.comalatech.confluence.workflow.analytics.usecases.appsusagesharing.AppUsageShareOnDemandGenerationUseCase;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;

public class AbstractWorkflowDataAction
extends ConfluenceActionSupport {
    private AdhocWorkflowsLicenseManager licenseManager;
    private DispatcherAnalyticsManager dispatcherAnalyticsManager;
    private PageManager pageManager;
    private AppUsageShareOnDemandGenerationUseCase appUsageShareOnDemandGenerationUseCase;
    private WorkflowsUsageReportService workflowsUsageReportService;
    private static final String RECENT_APPROVAL_DATE_FORMAT = "yyyy-MM-dd HH:mm";

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    public long getActivePages() {
        return this.dispatcherAnalyticsManager.getActivePages();
    }

    public long getTotalPages() {
        return this.dispatcherAnalyticsManager.getTotalPages();
    }

    public long getActiveSpaces() {
        List<WorkflowsUsageReport> report = this.workflowsUsageReportService.getSpacesReport();
        return report.stream().map(r -> r.getSpace().getSpaceKey()).collect(Collectors.toSet()).size();
    }

    public long getTotalSpaces() {
        return this.dispatcherAnalyticsManager.getTotalSpaces();
    }

    public String getRecentApprovalContent() {
        String contentId = (String)this.dispatcherAnalyticsManager.getAnalyticsEntry(BandanaKeysCatalog.LATEST_CONTENT_APPROVED_OR_REJECTED_KEY);
        if (contentId != null) {
            Page page = this.pageManager.getPage(Long.parseLong(contentId));
            return page != null ? page.getTitle() : "";
        }
        return "";
    }

    public String getRecentApprovalDate() {
        Long date = this.dispatcherAnalyticsManager.getTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_APPROVED_OR_REJECTED_KEY);
        if (date != 0L) {
            return DateFormatUtils.format((long)date, (String)RECENT_APPROVAL_DATE_FORMAT);
        }
        return "";
    }

    public String getAppUsageData() {
        String appUsageData = this.appUsageShareOnDemandGenerationUseCase.generateAppUsage();
        if (appUsageData != null) {
            return new JSONObject(appUsageData).toString(4);
        }
        return "";
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setDispatcherAnalyticsManager(DispatcherAnalyticsManager dispatcherAnalyticsManager) {
        this.dispatcherAnalyticsManager = dispatcherAnalyticsManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setAppUsageShareOnDemandGenerationUseCase(AppUsageShareOnDemandGenerationUseCase appUsageShareOnDemandGenerationUseCase) {
        this.appUsageShareOnDemandGenerationUseCase = appUsageShareOnDemandGenerationUseCase;
    }

    public void setWorkflowsUsageReportService(WorkflowsUsageReportService workflowsUsageReportService) {
        this.workflowsUsageReportService = workflowsUsageReportService;
    }
}

